/*
 * Decompiled with CFR 0.152.
 */
package net.f5.image;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class Bmp {
    int iDataOffset;
    int[] pixel = null;
    BufferedInputStream imageFile;
    int bfSize;
    int bfOffBits;
    int biSize;
    int biWidth;
    int biHeight;
    int biPlanes;
    int biBitCount;
    int biCompression;
    int biSizeImage;
    int biXPelsPerMeter;
    int biYPelsPerMeter;
    int biClrUsed;
    int biClrImportant;

    public Bmp(String fileName) {
        try {
            this.imageFile = new BufferedInputStream(new FileInputStream(fileName));
            this.readBitmapFileHeader();
            this.readBitmapInfoHeader();
            this.pixel = new int[this.biWidth * this.biHeight];
            int padding = 3 * this.biWidth % 4;
            if (padding > 0) {
                padding = 4 - padding;
            }
            for (int y = 1; y <= this.biHeight; ++y) {
                int x;
                int offset = (this.biHeight - y) * this.biWidth;
                for (x = 0; x < this.biWidth; ++x) {
                    this.pixel[offset + x] = this.readPixel();
                }
                for (x = 0; x < padding; ++x) {
                    this.imageFile.read();
                }
            }
        }
        catch (Exception e) {
            System.out.println(fileName + " is not a true colour file.");
            System.exit(1);
        }
    }

    void readBitmapFileHeader() throws Exception {
        if (this.imageFile.read() != 66) {
            throw new Exception();
        }
        if (this.imageFile.read() != 77) {
            throw new Exception();
        }
        this.bfSize = this.readInt();
        this.readInt();
        this.bfOffBits = this.readInt();
    }

    void readBitmapInfoHeader() throws Exception {
        this.biSize = this.readInt();
        this.biWidth = this.readInt();
        this.biHeight = this.readInt();
        this.biPlanes = this.readShort();
        this.biBitCount = this.readShort();
        if (this.biBitCount != 24) {
            throw new Exception();
        }
        this.biCompression = this.readInt();
        this.biSizeImage = this.readInt();
        this.biXPelsPerMeter = this.readInt();
        this.biYPelsPerMeter = this.readInt();
        this.biClrUsed = this.readInt();
        this.biClrImportant = this.readInt();
    }

    int readInt() throws IOException {
        int retVal = 0;
        for (int i = 0; i < 4; ++i) {
            retVal += (this.imageFile.read() & 0xFF) << 8 * i;
        }
        return retVal;
    }

    int readPixel() throws IOException {
        int retVal = 0;
        for (int i = 0; i < 3; ++i) {
            retVal += (this.imageFile.read() & 0xFF) << 8 * i;
        }
        return retVal | 0xFF000000;
    }

    int readShort() throws IOException {
        int retVal = this.imageFile.read() & 0xFF;
        return retVal += (this.imageFile.read() & 0xFF) << 8;
    }
}

