/*
 * Decompiled with CFR 0.152.
 */
package james;

import android.util.Log;
import info.guardianproject.f5android.Extract;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DCTStegoCE {
    private final double alpha = 0.8;
    private final double beta = 0.3333333333333333;
    private final int maxLenghtBits = 16;
    private final int maxCoeffs = 50000000;
    private final int maxCoeffRange = 127;

    public DCTStegoCE() {
        this.testAll();
    }

    public void testAll() {
        Log.d((String)"***** JPEG-STEGO ******", (String)"testAll() begin");
        boolean t1 = this.testEncodeBits2Byte();
        boolean t2 = this.testEncodeInt2Bytes();
        boolean t3 = this.testEmbedExtractBit();
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("TESTS: t1 %b t2 %b t3 %b", t1, t2, t3));
        Log.d((String)"***** JPEG-STEGO ******", (String)"testAll() end");
    }

    public boolean testEncodeBits2Byte() {
        int[] bits = new int[8];
        boolean res = true;
        for (int i = 0; i < 256; ++i) {
            this.encodeByteToBits(i, bits, 0);
            int j = this.encodeBitsToByte(bits, 0);
            if (i == j || !res) continue;
            res = false;
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("incorrect bs2b: i: %d j: %d", i, j));
            return false;
        }
        return res;
    }

    public boolean testEncodeInt2Bytes() {
        boolean res = true;
        int[] bytes = new int[this.maxLenghtBits / 8];
        for (int i = 0; i < 1 << this.maxLenghtBits; ++i) {
            this.encodeIntToBytes(i, bytes, 0, this.maxLenghtBits / 8);
            int j = this.encodeBytesToInt(bytes, 0, this.maxLenghtBits / 8);
            if (i == j || !res) continue;
            res = false;
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("incorrect i2bs: i: %d j: %d", i, j));
            return false;
        }
        return res;
    }

    public boolean testEmbedExtractBit() {
        boolean res = true;
        for (int type = 1; type <= 2; ++type) {
            for (int c = -10000; c <= 10000; ++c) {
                if (c == 0) continue;
                for (int bit = 0; bit <= 1; ++bit) {
                    int e;
                    int d = this.embedBit(type, c, bit);
                    if (d == 0) {
                        Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("0 generated by embedding: type: %d c: %d bit: %d d: %d", type, c, bit, d));
                    }
                    if (bit == (e = this.extractBit(type, d)) || !res) continue;
                    Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("embedding b: type: %d c: %d bit: %d d: %d e:%d", type, c, bit, d, e));
                    res = false;
                    return false;
                }
            }
        }
        return res;
    }

    private boolean isOdd(int x) {
        if (x >= 0) {
            return x % 2 == 1;
        }
        return -x % 2 == 1;
    }

    private boolean isEven(int x) {
        return !this.isOdd(x);
    }

    public int[] selectNonZeroCoeffs(int[] coeff) {
        int[] allNonZeroCoeffs = new int[coeff.length];
        int nonZeroCount = 0;
        for (int i = 0; i < coeff.length; ++i) {
            if (coeff[i] == 0) continue;
            allNonZeroCoeffs[nonZeroCount] = i;
            ++nonZeroCount;
        }
        int[] res = new int[nonZeroCount];
        System.arraycopy(allNonZeroCoeffs, 0, res, 0, nonZeroCount);
        return res;
    }

    public int[] getRandomPermutation(int amount) {
        int[] perm = new int[amount];
        for (int i = 0; i < amount; ++i) {
            perm[i] = i;
        }
        return perm;
    }

    public int[] getPermutedNonZeroCoeffs(int[] coeff) {
        int[] nonZeroCoeffs = this.selectNonZeroCoeffs(coeff);
        int[] perm = this.getRandomPermutation(nonZeroCoeffs.length);
        int[] qperm = new int[perm.length];
        for (int i = 0; i < qperm.length; ++i) {
            qperm[i] = nonZeroCoeffs[perm[i]];
        }
        return qperm;
    }

    public int[] getNon64PermutedNonZeroCoeffs(int[] coeff) {
        int[] qperm = this.getPermutedNonZeroCoeffs(coeff);
        int non64count = 0;
        for (int i = 0; i < qperm.length; ++i) {
            if (qperm[i] % 64 == 0) continue;
            qperm[non64count] = qperm[i];
            ++non64count;
        }
        int[] res = new int[non64count];
        System.arraycopy(qperm, 0, res, 0, non64count);
        return res;
    }

    public int[] getSmallCoeffs(int[] coeff, int type) {
        int[] qperm = this.getNon64PermutedNonZeroCoeffs(coeff);
        int[] good_coeffs = new int[qperm.length];
        int goodCount = 0;
        int maxCoeff = -100000;
        int minCoeff = 100000;
        for (int i = 0; i < qperm.length; ++i) {
            if (coeff[qperm[i]] < -this.maxCoeffRange || coeff[qperm[i]] > this.maxCoeffRange) {
                // empty if block
            }
            good_coeffs[goodCount] = qperm[i];
            ++goodCount;
            if (coeff[qperm[i]] > maxCoeff) {
                maxCoeff = coeff[qperm[i]];
            }
            if (coeff[qperm[i]] >= minCoeff) continue;
            minCoeff = coeff[qperm[i]];
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("maxCoeff %d minCoeff %d", maxCoeff, minCoeff));
        int[] res = new int[goodCount];
        System.arraycopy(good_coeffs, 0, res, 0, goodCount);
        return res;
    }

    public int[] getGoodCoeffs(int[] coeff) {
        return this.getSmallCoeffs(coeff, 0);
    }

    public void encodeByteToBits(int x, int[] dst, int pos) {
        for (int i = 0; i < 8; ++i) {
            dst[pos + i] = x >> i & 1;
        }
    }

    public int encodeBitsToByte(int[] src, int pos) {
        int x = 0;
        for (int i = 0; i < 8; ++i) {
            x += src[pos + i] << i;
        }
        return x;
    }

    public void encodeIntToBytes(int x, int[] dst, int pos, int length) {
        for (int i = 0; i < length; ++i) {
            dst[pos + i] = x >> 8 * i & 0xFF;
        }
    }

    public int encodeBytesToInt(int[] src, int pos, int length) {
        int x = 0;
        for (int i = 0; i < length; ++i) {
            x += src[pos + i] << 8 * i;
        }
        return x;
    }

    public int embedBitUnsafe(int type, int c, int bit) {
        if (c == 0) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"zero coeff!?!");
            return 0;
        }
        if (type == 1) {
            if (c > 0 && this.isOdd(c)) {
                if (bit == 0 && c - 1 == 0) {
                    return c - 2;
                }
                if (bit == 0 && c - 1 != 0) {
                    return c - 1;
                }
                if (bit == 1) {
                    return c;
                }
            } else if (c > 0 && this.isEven(c)) {
                if (bit == 1) {
                    return c - 1;
                }
                if (bit == 0) {
                    return c;
                }
            } else if (c < 0 && this.isOdd(c)) {
                if (bit == 1) {
                    return c - 1;
                }
                if (bit == 0) {
                    return c;
                }
            } else if (c < 0 && this.isEven(c)) {
                if (bit == 0) {
                    return c - 1;
                }
                if (bit == 1) {
                    return c;
                }
            }
        } else if (type == 2) {
            if (c > 0 && this.isOdd(c)) {
                if (bit == 1) {
                    return c + 1;
                }
                if (bit == 0) {
                    return c;
                }
            } else if (c > 0 && this.isEven(c)) {
                if (bit == 0) {
                    return c + 1;
                }
                if (bit == 1) {
                    return c;
                }
            } else if (c < 0 && this.isOdd(c)) {
                if (bit == 0 && c + 1 == 0) {
                    return c + 2;
                }
                if (bit == 0 && c + 1 != 0) {
                    return c + 1;
                }
                if (bit == 1) {
                    return c;
                }
            } else if (c < 0 && this.isEven(c)) {
                if (bit == 1) {
                    return c + 1;
                }
                if (bit == 0) {
                    return c;
                }
            }
        } else {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"type != {1, 2}");
            return 0;
        }
        Log.wtf((String)"***** JPEG-STEGO ******", (String)"embed bit: this should never occur");
        return 0;
    }

    public int embedBit(int type, int c, int bit) {
        int res = this.embedBitUnsafe(type, c, bit);
        if (res == 0) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("we embedded zero?!! type: %d c: %d bit: %d", type, c, bit));
        }
        return res;
    }

    public int extractBit(int type, int c) {
        if (c == 0) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"zero coeff!?!");
            return 0;
        }
        if (type == 1) {
            if (c > 0 && this.isEven(c)) {
                return 0;
            }
            if (c < 0 && this.isOdd(c)) {
                return 0;
            }
            if (c > 0 && this.isOdd(c)) {
                return 1;
            }
            if (c < 0 && this.isEven(c)) {
                return 1;
            }
        } else if (type == 2) {
            if (c > 0 && this.isOdd(c)) {
                return 0;
            }
            if (c < 0 && this.isEven(c)) {
                return 0;
            }
            if (c > 0 && this.isEven(c)) {
                return 1;
            }
            if (c < 0 && this.isOdd(c)) {
                return 1;
            }
        } else {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"type != {1, 2}");
            return 0;
        }
        Log.wtf((String)"***** JPEG-STEGO ******", (String)"extract bit: this should never occur");
        return 0;
    }

    public void embedPart(int type, int[] coeff, int[] qperm, int qbegin, int qend, int[] M) {
        int j;
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("embedPart: type: %d qbegin: %d qend: %d Mlength: %d", type, qbegin, qend, M.length));
        if (8 * M.length > qend - qbegin) {
            Log.e((String)"***** JPEG-STEGO ******", (String)"message is too long");
        }
        int[] octet = new int[8];
        for (j = 0; j < Math.min((qend - qbegin) / 8, M.length); ++j) {
            this.encodeByteToBits(M[j], octet, 0);
            for (int k = 0; k < 8; ++k) {
                int i = qperm[qbegin + j * 8 + k];
                coeff[i] = this.embedBit(type, coeff[i], octet[k]);
            }
        }
        if (type == 1) {
            for (j = 0; j < (int)(this.beta * (double)M.length * 8.0); ++j) {
                int i = qperm[qbegin + j];
                if (coeff[i] != -2) continue;
                coeff[i] = 1;
            }
        }
    }

    public void extractPart(int type, int[] coeff, int[] qperm, int qbegin, int qend, ByteArrayOutputStream fos) {
        this.extractPart(type, coeff, qperm, qbegin, qend, fos, null);
    }

    public void extractPart(int type, int[] coeff, int[] qperm, int qbegin, int qend, ByteArrayOutputStream fos, int[] S) {
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("extractPart: type: %d qbegin: %d qend: %d", type, qbegin, qend));
        int[] lengthCoeffs = new int[16];
        if (qend - qbegin < 16) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)"Coeffs are too small for length encoding?!!");
            return;
        }
        for (int i = 0; i < lengthCoeffs.length; ++i) {
            lengthCoeffs[i] = coeff[qperm[qbegin + i]];
        }
        int[] lengthBits = new int[lengthCoeffs.length];
        for (int i = 0; i < 16; ++i) {
            lengthBits[i] = this.extractBit(type, lengthCoeffs[i]);
        }
        int[] lengthBytes = new int[2];
        for (int i = 0; i < 2; ++i) {
            lengthBytes[i] = this.encodeBitsToByte(lengthBits, 8 * i);
        }
        int L = this.encodeBytesToInt(lengthBytes, 0, 2);
        Log.d((String)"***** JPEG-STEGO ******", (String)String.format("L: %d", L));
        qbegin += 16;
        int[] octet = new int[8];
        for (int j = 0; j < Math.min(L, (qend - qbegin) / 8); ++j) {
            for (int k = 0; k < 8; ++k) {
                int i = qperm[qbegin + j * 8 + k];
                octet[k] = this.extractBit(type, coeff[i]);
            }
            int b = this.encodeBitsToByte(octet, 0);
            if (S != null) {
                S[j] = b;
                continue;
            }
            fos.write(b);
        }
    }

    public int getQSep(int length) {
        return (int)(this.alpha * (double)length);
    }

    public void embed(int[] coeffOrig, InputStream embeddedData, int shuffleIndex) {
        try {
            int[] nz;
            int Clength = Math.min(this.maxCoeffs, coeffOrig.length);
            int[] coeff = new int[Clength];
            System.arraycopy(coeffOrig, 0, coeff, 0, Clength);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Embedding started");
            int[] qperm = this.getGoodCoeffs(coeff);
            Log.d((String)"***** JPEG-STEGO ******", (String)String.format("qperm length: %d", qperm.length));
            int Qsep = this.getQSep(qperm.length);
            int Slength = 0;
            try {
                Slength = embeddedData.available();
            }
            catch (IOException e) {
                Log.wtf((String)"***** JPEG-STEGO ******", (String)"error during embeddedData.length extraction");
                e.printStackTrace();
            }
            Log.d((String)"***** JPEG-STEGO ******", (String)String.format("Slength: %d", Slength));
            int[] S = new int[Slength];
            for (int i = 0; i < Slength; ++i) {
                try {
                    S[i] = embeddedData.read();
                    continue;
                }
                catch (IOException e) {
                    Log.wtf((String)"***** JPEG-STEGO ******", (String)"error during embeddedData extraction");
                    e.printStackTrace();
                }
            }
            int Ssep = this.getQSep(Slength);
            int[] M1 = new int[2 + Ssep];
            System.arraycopy(S, 0, M1, 2, Ssep);
            this.encodeIntToBytes(M1.length, M1, 0, 2);
            int[] M2 = new int[2 + Slength - Ssep];
            System.arraycopy(S, Ssep, M2, 2, Slength - Ssep);
            this.encodeIntToBytes(M2.length, M2, 0, 2);
            this.embedPart(1, coeff, qperm, 0, Qsep, M1);
            this.embedPart(2, coeff, qperm, Qsep, qperm.length, M2);
            System.arraycopy(coeff, 0, coeffOrig, 0, Clength);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Embedding ended");
            int[] ES1 = new int[Slength];
            this.extractPart(1, coeff, qperm, 0, Qsep, null, ES1);
            boolean s1correct = true;
            for (int i = 0; i < Ssep; ++i) {
                if (ES1[i] == M1[2 + i]) continue;
                s1correct = false;
                break;
            }
            if (!s1correct) {
                Log.e((String)"***** JPEG-STEGO ******", (String)"first part embedded incorrectly :(((");
            }
            int[] ES2 = new int[Slength];
            this.extractPart(2, coeff, qperm, Qsep, qperm.length, null, ES2);
            boolean s2correct = true;
            for (int i = 0; i < Slength - Ssep; ++i) {
                if (ES2[i] == M2[2 + i]) continue;
                s2correct = false;
                break;
            }
            if (!s2correct) {
                Log.e((String)"***** JPEG-STEGO ******", (String)"second part embedded incorrectly :(((");
            }
            if ((nz = this.getNon64PermutedNonZeroCoeffs(coeff)).length != qperm.length) {
                Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("Length of coeffs is not correct! old: %d new: %d", qperm.length, nz.length));
            }
        }
        catch (Exception e) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("Something went brutally wrong during embedding :/ Error: %s", e.toString()));
        }
    }

    public void extract(int[] coeffOrig, ByteArrayOutputStream fos, Extract.ExtractionListener listener) {
        try {
            int Clength = Math.min(this.maxCoeffs, coeffOrig.length);
            int[] coeff = new int[Clength];
            System.arraycopy(coeffOrig, 0, coeff, 0, Clength);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Extraction started");
            int[] qperm = this.getGoodCoeffs(coeff);
            Log.d((String)"***** JPEG-STEGO ******", (String)String.format("qperm length: %d", qperm.length));
            int Qsep = this.getQSep(qperm.length);
            this.extractPart(1, coeff, qperm, 0, Qsep, fos);
            this.extractPart(2, coeff, qperm, Qsep, qperm.length, fos);
            Log.d((String)"***** JPEG-STEGO ******", (String)"Extraction ended");
            listener.onExtractionResult(fos);
        }
        catch (Exception e) {
            Log.wtf((String)"***** JPEG-STEGO ******", (String)String.format("Something went brutally wrong during embedding :/ Error: %s", e.toString()));
        }
    }
}

