/*
 * Decompiled with CFR 0.152.
 */
package james;

import android.util.Log;
import info.guardianproject.f5android.Extract;
import james.DCTSteganography;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DCTStegoLSB
implements DCTSteganography {
    private final int maxLengthBits = 16;

    @Override
    public boolean loadKeyFromString(String s) {
        return true;
    }

    @Override
    public String generateStegoKeyString() {
        return "autobus";
    }

    public int setCoeffToBit(int coeff, int bit) {
        if (coeff >= 0) {
            if (coeff % 2 != bit) {
                return coeff + 1;
            }
            return coeff;
        }
        if (-coeff % 2 != bit) {
            return coeff - 1;
        }
        return coeff;
    }

    public int getBitFromCoeff(int coeff) {
        if (coeff >= 0) {
            return coeff % 2;
        }
        return -coeff % 2;
    }

    @Override
    public void embed(int[] coeff, InputStream embeddedData) {
        int i;
        Log.d((String)"***** JPEG-STEGO ******", (String)"embedding started");
        int bytesToEmbed = -1;
        try {
            bytesToEmbed = embeddedData.available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("length of secret message is " + String.valueOf(bytesToEmbed)));
        if (bytesToEmbed < 0 || bytesToEmbed >= 65536) {
            Log.e((String)"***** JPEG-STEGO ******", (String)"Length error: negative or too big");
            return;
        }
        String origCoeffsPref = "";
        for (i = 0; i < 100; ++i) {
            origCoeffsPref = origCoeffsPref + String.valueOf(coeff[i]) + ",\t";
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("orig coeff[]: " + origCoeffsPref));
        for (i = 0; i < 16; ++i) {
            coeff[i] = this.setCoeffToBit(coeff[i], bytesToEmbed % (1 << i + 1) / (1 << i));
        }
        for (i = 0; i < bytesToEmbed; ++i) {
            int secretByte = -1;
            try {
                secretByte = embeddedData.read();
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            for (int j = 0; j < 8; ++j) {
                int secretBit = secretByte % (1 << j + 1) / (1 << j);
                int pos = 16 + 8 * i + j;
                coeff[pos] = this.setCoeffToBit(coeff[pos], secretBit);
            }
        }
        String modiCoeffPref = "";
        for (int i2 = 0; i2 < 100; ++i2) {
            modiCoeffPref = modiCoeffPref + String.valueOf(coeff[i2]) + ",\t";
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("modi coeff[]: " + modiCoeffPref));
    }

    @Override
    public void extract(int[] coeff, ByteArrayOutputStream fos, Extract.ExtractionListener listener) {
        int i;
        Log.d((String)"***** JPEG-STEGO ******", (String)"extraction started");
        String origCoeffsPref = "";
        for (int i2 = 0; i2 < 100; ++i2) {
            origCoeffsPref = origCoeffsPref + String.valueOf(coeff[i2]) + ",\t";
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("enve coeff[]: " + origCoeffsPref));
        int[] lengthBits = new int[16];
        for (int i3 = 0; i3 < 16; ++i3) {
            lengthBits[i3] = this.getBitFromCoeff(coeff[i3]);
        }
        int length = 0;
        for (i = 15; i >= 0; --i) {
            length = 2 * length + lengthBits[i];
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)("length of embedded message is " + String.valueOf(length)));
        for (i = 0; i < length; ++i) {
            int embeddedByte = 0;
            for (int j = 7; j >= 0; --j) {
                int bit = this.getBitFromCoeff(coeff[16 + 8 * i + j]);
                embeddedByte = 2 * embeddedByte + bit;
            }
            fos.write(embeddedByte);
        }
        Log.d((String)"***** JPEG-STEGO ******", (String)"extraction finished.");
        listener.onExtractionResult(fos);
    }
}

