/*
 * Decompiled with CFR 0.152.
 */
package james;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.util.Log;
import james.JpegEncoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Jpeg {
    Activity a;
    File root_dir = new File(Environment.getExternalStorageDirectory(), "F5Android");
    File inFile;
    File outFile;
    FileOutputStream dataOut = null;
    JpegEncoder jpg;
    Bitmap image;
    BitmapFactory.Options opts;
    int Quality;
    public static final int DEFAULT_QUALITY = 80;
    public static final String LOG = "***** JPEG-STEGO ******";

    public Jpeg(Activity a, String in_file_name, String out_file_name) {
        this(a, in_file_name, 80, null);
    }

    public Jpeg(Activity a, String in_file_name) {
        this(a, in_file_name, 80, null);
    }

    public Jpeg(Activity a, String in_file_name, int quality) {
        this(a, in_file_name, quality, null);
    }

    public Jpeg(Activity a, String in_file_name, int quality, String out_file_name) {
        if (!this.root_dir.exists()) {
            this.root_dir.mkdir();
        }
        this.a = a;
        String string = new String();
        this.inFile = new File(in_file_name);
        if (in_file_name.endsWith(".jpg") && !in_file_name.endsWith(".tif") && !in_file_name.endsWith(".gif")) {
            Jpeg.StandardUsage();
        }
        if (out_file_name == null) {
            string = this.inFile.getName().substring(0, this.inFile.getName().lastIndexOf(".")) + ".jpg";
        } else {
            string = out_file_name;
            if (string.endsWith(".tif") || string.endsWith(".gif")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            if (!string.endsWith(".jpg")) {
                string = string.concat(".jpg");
            }
        }
        this.outFile = new File(this.root_dir, string);
        if (this.inFile.exists()) {
            try {
                this.dataOut = new FileOutputStream(this.outFile);
            }
            catch (IOException e) {
                Log.e((String)LOG, (String)e.toString());
                e.printStackTrace();
            }
        } else {
            Log.e((String)LOG, (String)("could not find the inFile? (" + this.inFile.getAbsolutePath() + ")"));
            return;
        }
        this.Quality = quality;
        this.opts = new BitmapFactory.Options();
        this.opts.inDither = false;
        this.opts.inPurgeable = true;
        this.opts.inInputShareable = true;
        this.opts.inTempStorage = new byte[32768];
        this.image = BitmapFactory.decodeFile((String)in_file_name);
        this.jpg = new JpegEncoder(this.image, this.Quality, this.dataOut, "", null);
    }

    public void compress(InputStream embedFile) {
        this.jpg.Compress(embedFile);
        try {
            this.dataOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setComment(String comment) {
        this.jpg.setComment(comment);
    }

    public static void StandardUsage() {
    }
}

