/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzpD();

    protected abstract Object zzcs(String var1);

    protected boolean zza(Field field) {
        if (field.zzpC() == 11) {
            if (field.zzpI()) {
                return this.zzcv(field.zzpJ());
            }
            return this.zzcu(field.zzpJ());
        }
        return this.zzct(field.zzpJ());
    }

    protected abstract boolean zzct(String var1);

    protected boolean zzcu(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzcv(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zzahd != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzpE() {
        return null;
    }

    public HashMap<String, Object> zzpF() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzpD();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzpC()) {
                case 8: {
                    stringBuilder.append("\"").append(zzmk.zzi((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzmk.zzj((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzmv.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzpH()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzpJ();
        if (field.zzpL() != null) {
            HashMap<String, Object> hashMap;
            zzx.zza(this.zzcs(field.zzpJ()) == null, "Concrete field shouldn't be value object: %s", field.zzpJ());
            HashMap<String, Object> hashMap2 = hashMap = field.zzpI() ? this.zzpF() : this.zzpE();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                String string3 = "get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                return this.getClass().getMethod(string3, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzcs(field.zzpJ());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzpB() == 11) {
            Class<FastJsonResponse> clazz = field.zzpL();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzpB() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzmu.zzcz((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzpB();

        public int zzpC();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    implements SafeParcelable {
        private final int mVersionCode;
        protected final int zzagU;
        protected final boolean zzagV;
        protected final int zzagW;
        protected final boolean zzagX;
        protected final String zzagY;
        protected final int zzagZ;
        protected final Class<? extends FastJsonResponse> zzaha;
        protected final String zzahb;
        private FieldMappingDictionary zzahc;
        private zza<I, O> zzahd;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int versionCode, int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, String concreteTypeName, ConverterWrapper wrappedConverter) {
            this.mVersionCode = versionCode;
            this.zzagU = typeIn;
            this.zzagV = typeInArray;
            this.zzagW = typeOut;
            this.zzagX = typeOutArray;
            this.zzagY = outputFieldName;
            this.zzagZ = safeParcelableFieldId;
            if (concreteTypeName == null) {
                this.zzaha = null;
                this.zzahb = null;
            } else {
                this.zzaha = SafeParcelResponse.class;
                this.zzahb = concreteTypeName;
            }
            this.zzahd = wrappedConverter == null ? null : wrappedConverter.zzpz();
        }

        protected Field(int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, Class<? extends FastJsonResponse> concreteType, zza<I, O> converter) {
            this.mVersionCode = 1;
            this.zzagU = typeIn;
            this.zzagV = typeInArray;
            this.zzagW = typeOut;
            this.zzagX = typeOutArray;
            this.zzagY = outputFieldName;
            this.zzagZ = safeParcelableFieldId;
            this.zzaha = concreteType;
            this.zzahb = concreteType == null ? null : concreteType.getCanonicalName();
            this.zzahd = converter;
        }

        public Field<I, O> zzpG() {
            return new Field<I, O>(this.mVersionCode, this.zzagU, this.zzagV, this.zzagW, this.zzagX, this.zzagY, this.zzagZ, this.zzahb, this.zzpO());
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzpB() {
            return this.zzagU;
        }

        public boolean zzpH() {
            return this.zzagV;
        }

        public int zzpC() {
            return this.zzagW;
        }

        public boolean zzpI() {
            return this.zzagX;
        }

        public String zzpJ() {
            return this.zzagY;
        }

        public int zzpK() {
            return this.zzagZ;
        }

        public Class<? extends FastJsonResponse> zzpL() {
            return this.zzaha;
        }

        String zzpM() {
            if (this.zzahb == null) {
                return null;
            }
            return this.zzahb;
        }

        public boolean zzpN() {
            return this.zzahd != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zzahc = fieldMappingDictionary;
        }

        ConverterWrapper zzpO() {
            if (this.zzahd == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zzahd);
        }

        public Map<String, Field<?, ?>> zzpP() {
            zzx.zzw(this.zzahb);
            zzx.zzw(this.zzahc);
            return this.zzahc.zzcw(this.zzahb);
        }

        public I convertBack(O output) {
            return this.zzahd.convertBack(output);
        }

        public static Field<Integer, Integer> zzj(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Double, Double> zzk(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzl(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzm(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static Field<ArrayList<String>, ArrayList<String>> zzn(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzpB(), bl, zza2.zzpC(), false, string2, n, null, zza2);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            com.google.android.gms.common.server.response.zza.zza(this, out, flags);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zzagU).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zzagV).append('\n');
            stringBuilder.append("                typeOut=").append(this.zzagW).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zzagX).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zzagY).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zzagZ).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzpM()).append('\n');
            if (this.zzpL() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzpL().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zzahd == null ? "null" : this.zzahd.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

