package io.github.japdlsd.steganogram;

import android.util.Base64;
import android.util.Log;

import com.scottyab.aescrypt.AESCrypt;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.crypto.spec.SecretKeySpec;

import james.Jpeg;

/**
 * Created by askar on 24.4.2016.
 */
public class AESEncryption implements SymmetricEncryption {
    String key = null;

    private static final String HASH_ALGORITHM = "SHA-256";

    public static final int ivl = 16;

    public boolean loadKeyFromString (final String s) {
        this.key = s;
        if (s != null) {
            return true;
        }
        else {
            return false;
        }
    }

    public String generateCryptoKeyString () {
        byte[] a = new byte[3 * 20];
        java.security.SecureRandom srand = new java.security.SecureRandom();
        srand.nextBytes(a);
        return Base64.encodeToString(a, Base64.NO_WRAP);
    }

    private static SecretKeySpec generateKey(final String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        final MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] bytes = password.getBytes("UTF-8");
        digest.update(bytes, 0, bytes.length);
        byte[] key = digest.digest();

        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        return secretKeySpec;
    }

    public byte[] oldEncrypt(byte[] text) {
        String password = this.key;
        String message = Base64.encodeToString(text, Base64.NO_WRAP);
        try {
            String encryptedMsg = AESCrypt.encrypt(password, message);
            byte[] res = encryptedMsg.getBytes("UTF-8");
            return res;
        }catch (GeneralSecurityException e){
            //handle error
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Log.e(Jpeg.LOG, "error during encrypt");
        return null;
    }

    public byte[] encrypt (byte[] text) {
        // @TODO
        try {
            final SecretKeySpec key = generateKey(this.key);
            byte[] ivBytes = new byte[this.ivl];
            java.security.SecureRandom srand = new java.security.SecureRandom();
            srand.nextBytes(ivBytes);

            byte[] cipherText = AESCrypt.encrypt(key, ivBytes, text);

            byte[] res = new byte[cipherText.length + ivBytes.length];
            System.arraycopy(ivBytes, 0, res, 0, ivBytes.length);
            System.arraycopy(cipherText, 0, res, ivBytes.length, cipherText.length);

            return res;

        } catch (UnsupportedEncodingException e) {
            // @TODO handle exception
            Log.e("myApp", "crypto: " + e.toString());
            return null;
        }
        catch (Exception e) {
            Log.e("myApp", "crypto: " + e.toString());
            // @TODO handle the exception
            return null;
        }
    }

    public byte[] decrypt(byte[] message) {
        // @TODO
        try {
            final SecretKeySpec key = generateKey(this.key);

            byte[] ivBytes = new byte[this.ivl];
            System.arraycopy(message, 0, ivBytes, 0, this.ivl);
            byte[] decodedCipherText = new byte[message.length - this.ivl];
            System.arraycopy(message, this.ivl, decodedCipherText, 0, message.length - this.ivl);

            byte[] decryptedBytes = AESCrypt.decrypt(key, ivBytes, decodedCipherText);

            return decryptedBytes;
        } catch (UnsupportedEncodingException e) {
            // @TODO handle exception
            Log.e("myApp", "crypto: " + e.toString());
            return null;
        }
        catch (Exception e) {
            Log.e("myApp", "crypto: " + e.toString());
            // @TODO handle the exception
            return null;
        }
    }

    public byte[] oldDecrypt(byte[] message) {
        try {
            String encryptedMsg = new String(message, "UTF-8");

            String password = this.key;
            try {
                String messageAfterDecrypt = AESCrypt.decrypt(password, encryptedMsg);
                byte[] res = Base64.decode(messageAfterDecrypt, Base64.NO_WRAP);
                return res;
            }catch (GeneralSecurityException e){
                //handle error - could be due to incorrect password or tampered encryptedMsg
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Log.e(Jpeg.LOG, "error during decrypt");
        return null;
    }
}
