package io.github.japdlsd.steganogram;

import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EmbedMessageActivity extends AppCompatActivity {
    String mCurrentPhotoPath = null;
    Solution sol = new Solution(this);

    private File createImageFile() throws IOException {
        // Create an image file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_PICTURES);
        Log.d("myApp", "storageDir" + storageDir);
        File image = File.createTempFile(
                imageFileName,  /* prefix */
                ".jpg",         /* suffix */
                storageDir      /* directory */
        );

        // Save a file: path for use with ACTION_VIEW intents
        mCurrentPhotoPath = "file:" + image.getAbsolutePath();
        Log.d("myApp", mCurrentPhotoPath);
        return image;
    }

    static final int REQUEST_TAKE_PHOTO = 1;

    public void dispatchTakePictureIntent(View view) {
        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        // Ensure that there's a camera activity to handle the intent
        if (takePictureIntent.resolveActivity(getPackageManager()) != null) {
            // Create the File where the photo should go
            File photoFile = null;
            try {
                photoFile = createImageFile();
            } catch (IOException ex) {
                // Error occurred while creating the File
                Log.d("myApp", ex.toString());
            }
            // Continue only if the File was successfully created
            if (photoFile != null) {
                takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT,
                        Uri.fromFile(photoFile));
                startActivityForResult(takePictureIntent, REQUEST_TAKE_PHOTO);
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d("myApp", "onActivityResult");
        if (requestCode == REQUEST_TAKE_PHOTO && resultCode == RESULT_OK) {
            Log.d("myApp", "correct request code");
            // draw photo on display
            // @TODO correct rotation of the cover image thumbnail
            ImageView tn = (ImageView) findViewById(R.id.cover_image_thumbnail);
            tn.setImageURI(Uri.parse(mCurrentPhotoPath));
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d("myApp", "onCreate()");
        setContentView(R.layout.activity_embed_message);
    }

    public void  startEmbeddingMessage(View view) {
        if (this.mCurrentPhotoPath != null) {
            Uri cleanImageUri = Uri.parse(this.mCurrentPhotoPath);
            String secretMessage = String.valueOf(((EditText) findViewById(R.id.secret_message)).getText());
            String outputFilename = String.valueOf(((EditText) findViewById(R.id.output_filename)).getText());

            this.sol.loadImageFromUri(cleanImageUri);
            this.sol.embedMessage(secretMessage);
            this.sol.saveImageWithName(outputFilename);

            // @TODO loading bar during embedding process (although it should be fast)
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        Log.d("myApp", "onStart()");
    }

    @Override
    public void onStop() {
        super.onStop();
        Log.d("myApp", "onStop()");
    }

    @Override
    public void onPause() {
        super.onPause();
        Log.d("myApp", "onPause()");
    }

    @Override
    public void onResume() {
        super.onResume();
        Log.d("myApp", "onResume()");
    }

    @Override
    public void onDestroy () {
        super.onDestroy();
        Log.d("myApp", "onDestroy");
        // @TODO remove all cover images from internal memory
    }
}
