package io.github.japdlsd.steganogram;

import android.content.Intent;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import java.io.ByteArrayOutputStream;
import java.io.File;

import info.guardianproject.f5android.Extract;

public class ExtractMessageActivity extends AppCompatActivity implements Solution.ExtractionStringListener {

    public final int RESULT_LOAD_IMG = 14;
    String imgDecodableString;
    public Uri coverImageUri = null;
    public Solution sol = new Solution(this);

    public void chooseImageToExtract(View view) {
        // @TODO select image from Gallery
        Intent galleryIntent = new Intent(Intent.ACTION_PICK,
                android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        // Start the Intent
        startActivityForResult(galleryIntent, RESULT_LOAD_IMG);
    }

    public void startExtractingMessage(View view) {
        // @TODO call the Solution to extract message
        // get the path
        if (this.coverImageUri == null) {
            return;
        }

        // @TODO show sent message
        this.sol.loadImageFromUri(this.coverImageUri);
        /*String secretMessage = this.sol.extractMessage();
        Log.d("myApp", "secret message: " + secretMessage);
        TextView extractedTextView = (TextView) findViewById(R.id.extracted_textview);
        extractedTextView.setText(secretMessage);*/
        this.sol.extractMessageWithCallback(this);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            // When an Image is picked
            if (requestCode == RESULT_LOAD_IMG && resultCode == RESULT_OK
                    && null != data) {
                // Get the Image from data

                this.coverImageUri = data.getData();
                Log.d("myApp", "coverImageUri: " + this.coverImageUri);
                //String[] filePathColumn = { MediaStore.Images.Media.DATA };

                // Get the cursor
                //Cursor cursor = getContentResolver().query(selectedImage,
                //        filePathColumn, null, null, null);
                // Move to first row
                //cursor.moveToFirst();

                //int columnIndex = cursor.getColumnIndex(filePathColumn[0]);
                //imgDecodableString = cursor.getString(columnIndex);
                //cursor.close();
                //ImageView imgView = (ImageView) findViewById(R.id.imgView);
                // Set the Image in ImageView after decoding the String
                //imgView.setImageBitmap(BitmapFactory
                //        .decodeFile(imgDecodableString));

            } else {
                Toast.makeText(this, "You haven't picked Image",
                        Toast.LENGTH_LONG).show();
            }
        } catch (Exception e) {
            Toast.makeText(this, "Something went wrong", Toast.LENGTH_LONG)
                    .show();
        }

    }

    @Override
    public void onExtractionResult (String message) {
        Log.d("myApp", "secret message: " + message);
        TextView extractedTextView = (TextView) findViewById(R.id.extracted_textview);
        extractedTextView.setText(message);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_extract_message);
    }

    @Override
    public void onStart() {
        super.onStart();
        Log.d("myApp", "onStart()");
    }

    @Override
    public void onStop() {
        super.onStop();
        Log.d("myApp", "onStop()");
    }

    @Override
    public void onPause() {
        super.onPause();
        Log.d("myApp", "onPause()");
    }

    @Override
    public void onResume() {
        super.onResume();
        Log.d("myApp", "onResume()");
    }

    @Override
    public void onDestroy () {
        super.onDestroy();
        Log.d("myApp", "onDestroy");
    }
}
