package james;

import android.media.JetPlayer;
import android.util.Log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import info.guardianproject.f5android.Extract;
import sun.security.provider.SecureRandom;

import static java.lang.Math.*;

/**
 * Created by askar on 17.4.2016.
 */
public class DCTStegoCEOld {
    // complementary embedding

    // discussed in part 4.4 (for S-family attack resistance)
    final private double alpha = 4.0 / 5.0;
    final private double beta = 1.0 / 3.0;
    final private int maxLenghtBits = 8 * 2;

    public DCTStegoCEOld() {
        this.testAll();
    }

    public void testAll () {

    }

    public boolean testBitToByte () {
        return true;
    }

    public void embed (int coeff[], final InputStream embeddedData, int shuffleIndex) {
        Log.d(Jpeg.LOG, "embedding started");
        // step 1 -- done already

        // step 2 -- done already

        // step 3

        int[] Qperm = new int[coeff.length];
        // @TODO serious permutation
        for (int i = 0; i < coeff.length; i++) {
            Qperm[i] = i;
        }
        // so Q[i] == coeff[Qperm[i]]

        // step 4
        // half open intervals
        final int Q1begin = 0;
        final int Q1end = (int) ceil(coeff.length * alpha);
        Log.d(Jpeg.LOG, "Q1: " + String.valueOf(Q1begin) + " " + String.valueOf(Q1end));

        final int Q2begin = Q1end;
        final int Q2end = coeff.length;
        Log.d(Jpeg.LOG, "Q2: " + String.valueOf(Q2begin) + " " + String.valueOf(Q2end));

        // so  Q1 is coeff[Qperm[Q1begin .. Q1end - 1]]
        // and Q2 is coeff[Qperm[Q2begin .. Q2end - 1]]

        // step 5
        int Slength = 0;
        try {
            Slength = embeddedData.available();
        } catch (IOException e) {
            // @TODO add serious error handling
            e.printStackTrace();
        }
        Log.d(Jpeg.LOG, "Slength: " + String.valueOf(Slength));

        int[] S = new int[Slength];
        for (int i = 0; i < Slength; i++) {
            try {
                S[i] = embeddedData.read();
            } catch (IOException e) {
                // @TODO add serious error handliing
                e.printStackTrace();
            }
        }


        // step 6
        final int L1 = (int) ceil(Slength * alpha);
        Log.d(Jpeg.LOG, "L1: " + String.valueOf(L1));
        final int L2 = Slength - L1;
        Log.d(Jpeg.LOG, "L2: " + String.valueOf(L2));

        // @TODO assert L1 < (1 << maxLengthBits)
        // @TODO assert L2 < (1 << maxLenghtBits)

        int[] M1 = new int[maxLenghtBits/8 + L1];
        System.arraycopy(S, 0, M1, maxLenghtBits/8, L1);

        int[] M2 = new int[maxLenghtBits/8 + L2];
        System.arraycopy(S, L1, M2, maxLenghtBits/8, L2);

        // step 7
        // step 8
        for (int i = 0; i < maxLenghtBits/8; i++) {
            // least significant first <--> little endian
            M1[i] = L1 % (1 << (8*(i+1))) / (1 << (8*i));
            M2[i] = L2 % (1 << (8*(i+1))) / (1 << (8*i));
        }

        // step 9
        // step 10
        this.embedE1(coeff, Qperm, Q1begin, Q1end, M1);
        this.embedE2(coeff, Qperm, Q2begin, Q2end, M2);

        // step 11 -- done already
        // step 12 -- done already (nothing has been permuted (we just use permuted index))
        // step 13 -- done already
    }

    private int[] makeBitsFromByte (final int m) {
        int[] octet = new int[8];
        for (int i = 0; i < 8; i++) {
            octet[i] = m % (1 << (i+1)) / (1 << i);
        }
        return octet;
    }

    private int makeByteFromBits (final int[] a, final int pos) {
        int res = 0;
        for (int i = 7; i >= 0; i--) {
            res = 2 * res + a[pos + i];
        }
        return res;
    }

    private int[] makeBitSequenceFromByteSequence (final int[] m) {
        int[] B = new int[m.length * 8];
        for (int i = 0; i < m.length; i++) {
            int[] octet = makeBitsFromByte(m[i]);
            System.arraycopy(octet, 0, B, i*8, 8);
        }
        return B;
    }

    private boolean isOdd (final int x) {
        if (x >= 0) {
            return (x % 2) == 1;
        }
        else {
            return ((-x) % 2) == 1;
        }
    }

    private boolean isEven (final int x) {
        return !isOdd(x);
    }

    private void embedE1(int[] C, final int[] qperm, final int qbegin, final int qend, final int[] m) {
        // B - the bit sequence to be embedded
        int[] B = makeBitSequenceFromByteSequence(m);
        // C coefficient sequence: C[i] === coeff[qperm[qbegin + i]]
        // beta is in this.beta

        int b = 0; // position in secret message bits B[]
        for (int j = 0; j < qend - qbegin; j++) {
            if (b == B.length) {
                break;
            }
            final int i = qperm[qbegin + j];
            // now C[i] is as in the paper
            final int Bi = B[b]; // embedded coefficient

            if (C[i] == 0) {
                continue;
                // skipping zeros
            }
            else if (C[i] > 0 && isOdd(C[i])) {
                if (Bi == 0 && C[i] - 1 == 0) {
                    C[i] = C[i] - 2;
                }
                else if (Bi == 0 && C[i] - 1 != 0) {
                    C[i] = C[i] - 1;
                }
                else if (Bi == 1) {
                    //C[i] = C[i];
                    // intentionally left blank
                }
                else {
                    // @TODO raise alarm!
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else if (C[i] > 0 && isEven(C[i])) {
                if (Bi == 1) {
                    C[i] = C[i] - 1;
                }
                else if (Bi == 0) {
                    //C[i] = C[i];
                    // intentionally left blank
                }
                else {
                    // @TODO correct error handling
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else if (C[i] < 0 && isOdd(C[i])) {
                if (Bi == 1) {
                    C[i] = C[i] - 1;
                }
                else if (Bi == 0) {
                    // C[i] = C[i];
                    // intentionally left blank
                }
                else {
                    // @TODO correct error handling
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else if (C[i] < 0 && isEven(C[i])) {
                if (Bi == 0) {
                    C[i] = C[i] - 1;
                }
                else if (Bi == 1) {
                    //C[i] = C[i];
                    // intentionally left blank
                }
                else {
                    // @TODO correct error handling
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else {
                // intentionally left blank
            }
            b++;
        }
        if (b < B.length) {
            Log.e(Jpeg.LOG, "message is too long, only part of the message has been embedded");
            // @TODO correct error handling
        }

        b = 0;
        for (int j = 0; j < qend - qbegin; j++) {
            if (b >= beta * B.length - 1) {
                break;
            }
            final int i = qperm[qbegin + j];
            if (C[i] == 0) {
                continue;
            }
            if (C[i] == -2) {
                C[i] = 1;
            }
            b++;
        }
        if (b < beta * B.length - 1) {
            // @TODO correct error handling
        }
    }


    private void embedE2(int[] C, final int[] qperm, final int qbegin, final int qend, final int[] m) {
        // B - the bit sequence to be embedded
        int[] B = makeBitSequenceFromByteSequence(m);
        // C coefficient sequence: C[i] === coeff[qperm[qbegin + i]]
        // beta is in this.beta

        int b = 0; // position in secret message bits B[]
        for (int j = 0; j < qend - qbegin; j++) {
            if (b == B.length) {
                break;
            }
            final int i = qperm[qbegin + j];
            // now C[i] is as in the paper
            final int Bi = B[b]; // embedded coefficient

            if (C[i] == 0) {
                // skipping zeros
                continue;
            }
            else if (C[i] > 0 && isOdd(C[i])) {
                if (Bi == 1) {
                    C[i] = C[i] + 1;
                }
                else if (Bi == 0) {
                    // C[i] = C[i]
                    // intentionally left blank
                }
                else {
                    // @TODO raise alarm!
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else if (C[i] > 0 && isEven(C[i])) {
                if (Bi == 1) {
                    C[i] = C[i] + 1;
                }
                else if (Bi == 0) {
                    // intentionally left blank
                }
                else {
                    // @TODO correct error handling
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else if (C[i] < 0 && isOdd(C[i])) {
                if (Bi == 0 && C[i] + 1 == 0) {
                    C[i] = C[i] + 2;
                }
                else if (Bi == 0 && C[i] + 1 != 0) {
                    C[i] = C[i] + 1;
                }
                else if (Bi == 1) {
                    // intentionally left blank
                }
                else {
                    // @TODO correct error handling
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else if (C[i] < 0 && isEven(C[i])) {
                if (Bi == 1) {
                    C[i] = C[i] + 1;
                }
                else if (Bi == 0) {
                    // left blank intentionally
                }
                else {
                    // @TODO correct error handling
                    Log.e(Jpeg.LOG, "B is not 0 or 1!!!");
                }
            }
            else {
                // intentionally left blank
            }
            b++;
        }
        if (b < B.length) {
            Log.e(Jpeg.LOG, "message is too long, only part of the message has been embedded");
            // @TODO correct error handling
        }

        b = 0;
        for (int j = 0; j < qend - qbegin; j++) {
            if (b >= beta * B.length - 1) {
                break;
            }
            final int i = qperm[qbegin + j];
            if (C[i] == 0) {
                continue;
            }
            if (C[i] == -2) {
                C[i] = 1;
            }
            b++;
        }
        if (b < beta * B.length - 1) {
            // @TODO correct error handling
        }
    }

    public void extract (int coeff[],  ByteArrayOutputStream fos, Extract.ExtractionListener listener) {
        Log.d(Jpeg.LOG, "extraction started");

        // testing
        final boolean tres1 = this.testMakeBitFromByte();

        // step 1 -- already done

        // step 2
        int[] qperm = new int[coeff.length];
        // @TODO serious permutation
        for (int i = 0; i < qperm.length; i++) {
            qperm[i] = i;
        }

        // step 3
        // half open intervals
        final int Q1begin = 0;
        final int Q1end = (int) ceil(coeff.length * alpha);
        Log.d(Jpeg.LOG, "Q1: " + String.valueOf(Q1begin) + " " + String.valueOf(Q1end));


        final int Q2begin = Q1end;
        final int Q2end = coeff.length;
        Log.d(Jpeg.LOG, "Q2: " + String.valueOf(Q2begin) + " " + String.valueOf(Q2end));

        // step 4
        int[][] L1extraction = this.extractLengthCoeffs(coeff, qperm, Q1begin, Q1end);
        int[] L1Coeffs = L1extraction[0];
        int j1 = L1extraction[1][0];

        int[] L1Bits = new int[maxLenghtBits];
        for (int i = 0; i < maxLenghtBits; i++) {
            L1Bits[i] = this.extractBitFromCoeffE1(L1Coeffs[i]);
        }
        int[] L1Bytes = new int[maxLenghtBits/8];
        for (int i = 0; i < maxLenghtBits/8; i++) {
            L1Bytes[i] = this.makeByteFromBits(L1Bits, i * 8);
        }

        int L1 = 0;
        for (int i = maxLenghtBits/8 - 1; i >= 0; i--) {
            L1 = (L1 << 8) + L1Bytes[i];
        }
        Log.d(Jpeg.LOG, "L1 == " + String.valueOf(L1));
        // step 5
        this.extractE1(coeff, qperm, Q1begin + j1, Q1end, L1, fos);

        // step 6
        int[][] L2extraction = this.extractLengthCoeffs(coeff, qperm, Q2begin, Q2end);
        int[] L2Coeffs = L2extraction[0];
        int j2 = L2extraction[1][0];

        int[] L2Bits = new int[maxLenghtBits];
        for (int i = 0; i < maxLenghtBits; i++) {
            L2Bits[i] = this.extractBitFromCoeffE2(L2Coeffs[i]);
        }
        int[] L2Bytes = new int[maxLenghtBits/8];
        for (int i = 0; i < maxLenghtBits/8; i++) {
            L2Bytes[i] = this.makeByteFromBits(L2Bits, i * 8);
        }

        int L2 = 0;
        for (int i = maxLenghtBits/8 - 1; i >= 0; i--) {
            L2 = (L2 << 8) + L2Bytes[i];
        }

        Log.d(Jpeg.LOG, "L2 == " + String.valueOf(L2));

        // step 7
        this.extractE2(coeff, qperm, Q2begin + j2, Q2end, L2, fos);

        // step 8
        // done by pouring bytes into fos

        // step 9 -- already done

        Log.d(Jpeg.LOG, "extraction finished.");
        listener.onExtractionResult(fos);
    }

    private int[][] extractLengthCoeffs (final int[] coeff, final int[] qperm, final int qbegin, final int qend) {
        int j; // running through qperm

        int[] lengthCoeffs = new int[this.maxLenghtBits];
        int l = 0; // running through lengthCoeffs
        for (j = 0; j < qend - qbegin; j++) {
            if (l == lengthCoeffs.length) {
                break;
            }
            final int i = qperm[qbegin + j];
            final int Ci = coeff[i];
            if (Ci == 0) {
                continue;
            }
            lengthCoeffs[l] = Ci;
            l++;
        }
        if (l < lengthCoeffs.length) {
            Log.e(Jpeg.LOG, "not enough bits for length. dafuq");
            // @TODO correct error handling
        }

        int[] params = {j};

        int[][] res = new int[2][];
        res[0] = lengthCoeffs;
        res[1] = params;
        return res;
    }

    private int extractBitFromCoeffE1 (final int c) {
        if (c > 0 && isEven(c)) return 0;
        if (c < 0 && isOdd(c))  return 0;
        if (c > 0 && isOdd(c))  return 1;
        if (c < 0 && isEven(c)) return 1;

        Log.wtf(Jpeg.LOG, "zero coeff!?!");
        // @TODO add correct handling
        return 0;
    }

    private int extractBitFromCoeffE2 (final int c) {
        if (c > 0 && isOdd(c))  return 0;
        if (c < 0 && isEven(c)) return 0;
        if (c > 0 && isEven(c)) return 1;
        if (c < 0 && isOdd(c))  return 1;

        Log.wtf(Jpeg.LOG, "zero coeff!?!");
        // @TODO add correct handling
        return 0;
    }

    private void extractE1 (final int[] coeff, final int[] qperm, final int qbegin, final int qend, final int L, ByteArrayOutputStream fos) {
        int l = 0;
        for (int j = 0; j < qend - qbegin; j++) {
            if (l == L) {
                break;
            }
            final int i = qperm[qbegin + j];
            final int Ci = coeff[i];
            if (Ci == 0) {
                continue;
            }

            fos.write(extractBitFromCoeffE1(Ci));
            l++;

        }
        if (l < L) {
            Log.w(Jpeg.LOG, "message is too long");
            // @TODO add correct error handling
        }
    }

    private void extractE2 (final int[] coeff, final int[] qperm, final int qbegin, final int qend, final int L, ByteArrayOutputStream fos) {
        int l = 0;
        for (int j = 0; j < qend - qbegin; j++) {
            if (l == L) {
                break;
            }
            final int i = qperm[qbegin + j];
            final int Ci = coeff[i];
            if (Ci == 0) {
                continue;
            }

            fos.write(extractBitFromCoeffE2(Ci));
            l++;

        }
        if (l < L) {
            Log.w(Jpeg.LOG, "message is too long");
            // @TODO add correct error handling
        }
    }

    private boolean testMakeBitFromByte () {
        for (int i = 0; i < 256; i++) {
            int[] encoded = this.makeBitsFromByte(i);
            String Sencoded = "";
            for (int j = 0; j < encoded.length; j++) {
                Sencoded += String.valueOf(encoded[j]) + ", ";
            }
            final int res = this.makeByteFromBits(encoded, 0);
            if (res != i) {
                Log.wtf(Jpeg.LOG, "i: " + String.valueOf(i) + " S: " + Sencoded + " res: " + String.valueOf(res));
            }
        }

        return true;
    }
}
