package james;

import android.util.Log;

import net.f5.crypt.F5Random;
import net.f5.crypt.Permutation;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;

import info.guardianproject.f5android.Extract;

/**
 * Created by askar on 22.4.2016.
 */
public class DCTStegoEnvelop {
    int n = 0;
    InputStream embeddedData;
    private static byte[] deZigZag = {
            0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31,
            40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61,
            35, 36, 48, 49, 57, 58, 62, 63 };

    private DCTStegoLSB steganograph = null;

    public void DCTStegoEnvelop() {
        this.steganograph = new DCTStegoLSB();
    }

    public void embed (int coeff[], final InputStream embeddedData, int shuffledIndex) {
        int coeffCount = coeff.length;
        this.embeddedData = embeddedData;



        ArrayList<Integer> goodCoeffs = new ArrayList<Integer>(0);

        int _changed = 0;
        int _embedded = 0;
        int _examined = 0;
        int _expected = 0;
        int _one = 0;
        int _large = 0;
        int _thrown = 0;
        int _zero = 0;
        int i, j;

        for (i = 0; i < coeffCount; i++) {
            if (i % 64 == 0) {
                continue;
            }
            if (coeff[i] == 1) {
                _one++;
            }
            if (coeff[i] == -1) {
                _one++;
            }
            if (coeff[i] == 0) {
                _zero++;
            }
        }
        _large = coeffCount - _zero - _one - coeffCount / 64;
        _expected = _large + (int) (0.49 * _one);
        //
        // System.out.println("zero="+_zero);
        Log.d(Jpeg.LOG, "one=" + _one);
        Log.d(Jpeg.LOG, "large=" + _large);
        //
        Log.d(Jpeg.LOG, "expected capacity: " + _expected + " bits");
        Log.d(Jpeg.LOG, "expected capacity with");
        for (i = 1; i < 8; i++) {
            int usable, changed, n;
            n = (1 << i) - 1;
            usable = _expected * i / n - _expected * i / n % n;
            changed = coeffCount - _zero - coeffCount / 64;
            changed = changed * i / n - changed * i / n % n;
            changed = n * changed / (n + 1) / i;
            //
            changed = _large - _large % (n + 1);
            changed = (changed + _one + _one / 2 - _one / (n + 1)) / (n + 1);
            usable /= 8;
            if (usable == 0) {
                break;
            }
            if (i == 1) {
                Log.d(Jpeg.LOG, "default");
            } else {
                Log.d(Jpeg.LOG, "(1, " + n + ", " + i + ")");
            }
            Log.d(Jpeg.LOG, " code: " + usable + " bytes (efficiency: " + usable * 8 / changed + "." + usable * 80
                    / changed % 10 + " bits per change)");
        }

        // westfeld
        if (this.embeddedData != null) {
            // Now we embed the secret data in the permutated sequence.
            Log.d(Jpeg.LOG, "Permutation starts");
            final F5Random random = new F5Random();
            final Permutation permutation = new Permutation(coeffCount, random);
            int nextBitToEmbed = 0;
            int byteToEmbed = 0;
            int availableBitsToEmbed = 0;
            // We start with the length information. Well,
            // the length information it is more than one
            // byte, so this first "byte" is 32 bits long.
            try {
                byteToEmbed = this.embeddedData.available();
            } catch (final Exception e) {
                e.printStackTrace();
            }
            Log.d(Jpeg.LOG, "Embedding of " + (byteToEmbed * 8 + 32) + " bits (" + byteToEmbed + "+4 bytes) ");
            // We use the most significant byte for the 1 of n
            // code, and reserve one extra bit for future use.
            if (byteToEmbed > 0x007fffff) {
                byteToEmbed = 0x007fffff;
            }
            // We calculate n now
            for (i = 1; i < 8; i++) {
                int usable;
                final int changed;
                this.n = (1 << i) - 1;
                usable = _expected * i / this.n - _expected * i / this.n % this.n;
                usable /= 8;
                if (usable == 0) {
                    break;
                }
                if (usable < byteToEmbed + 4) {
                    break;
                }
            }
            final int k = i - 1;
            this.n = (1 << k) - 1;
            switch (this.n) {
                case 0:
                    Log.d(Jpeg.LOG, "using default code, file will not fit");
                    this.n++;
                    break;
                case 1:
                    Log.d(Jpeg.LOG, "using default code");
                    break;
                default:
                    Log.d(Jpeg.LOG, "using (1, " + this.n + ", " + k + ") code");
            }
            byteToEmbed |= k << 24; // store k in the status word
            // Since shuffling cannot hide the distribution, the
            // distribution of all bits to embed is unified by
            // adding a pseudo random bit-string. We continue the random
            // we used for Permutation, initially seeked with password.
            byteToEmbed ^= random.getNextByte();
            byteToEmbed ^= random.getNextByte() << 8;
            byteToEmbed ^= random.getNextByte() << 16;
            byteToEmbed ^= random.getNextByte() << 24;
            nextBitToEmbed = byteToEmbed & 1;
            byteToEmbed >>= 1;
            availableBitsToEmbed = 31;
            _embedded++;
            if (this.n > 1) { // use 1 of n code
                int kBitsToEmbed;
                int extractedBit;
                final int[] codeWord = new int[this.n];
                int hash;
                int startOfN = 0;
                int endOfN = 0;
                boolean isLastByte = false;
                // embed status word first
                for (i = 0; i < coeffCount; i++) {
                    shuffledIndex = permutation.getShuffled(i);
                    if (shuffledIndex % 64 == 0) {
                        continue; // skip DC coefficients
                    }
                    if (coeff[shuffledIndex] == 0) {
                        continue; // skip zeroes
                    }
                    if (coeff[shuffledIndex] > 0) {
                        // GOOD COEFF
                        goodCoeffs.add(shuffledIndex);

                        if ((coeff[shuffledIndex] & 1) != nextBitToEmbed) {
                            coeff[shuffledIndex]--; // decrease absolute value
                            _changed++;
                        }
                    } else {
                        goodCoeffs.add(shuffledIndex);

                        if ((coeff[shuffledIndex] & 1) == nextBitToEmbed) {
                            coeff[shuffledIndex]++; // decrease absolute value
                            _changed++;
                        }
                    }
                    if (coeff[shuffledIndex] != 0) {
                        // The coefficient is still nonzero. We
                        // successfully embedded "nextBitToEmbed".
                        // We will read a new bit to embed now.
                        if (availableBitsToEmbed == 0) {
                            break; // statusword embedded.
                        }
                        nextBitToEmbed = byteToEmbed & 1;
                        byteToEmbed >>= 1;
                        availableBitsToEmbed--;
                        _embedded++;
                    } else {
                        _thrown++;
                    }
                }
                startOfN = i + 1;
                // now embed the data using 1 of n code
                embeddingLoop: do {
                    kBitsToEmbed = 0;
                    // get k bits to embed
                    for (i = 0; i < k; i++) {
                        if (availableBitsToEmbed == 0) {
                            // If the byte of embedded text is
                            // empty, we will get a new one.
                            try {
                                if (this.embeddedData.available() == 0) {
                                    isLastByte = true;
                                    break;
                                }
                                byteToEmbed = this.embeddedData.read();
                                byteToEmbed ^= random.getNextByte();
                            } catch (final Exception e) {
                                e.printStackTrace();
                                break;
                            }
                            availableBitsToEmbed = 8;
                        }
                        nextBitToEmbed = byteToEmbed & 1;
                        byteToEmbed >>= 1;
                        availableBitsToEmbed--;
                        kBitsToEmbed |= nextBitToEmbed << i;
                        _embedded++;
                    }
                    // embed k bits
                    do {
                        j = startOfN;
                        // fill codeWord[] with the indices of the
                        // next n non-zero coefficients in coeff[]
                        for (i = 0; i < this.n; j++) {
                            if (j >= coeffCount) {
                                // in rare cases the estimated capacity is too
                                // small
                                Log.d(Jpeg.LOG, "Capacity exhausted.");
                                break embeddingLoop;
                            }
                            shuffledIndex = permutation.getShuffled(j);
                            if (shuffledIndex % 64 == 0) {
                                continue; // skip DC coefficients
                            }
                            if (coeff[shuffledIndex] == 0) {
                                continue; // skip zeroes
                            }
                            codeWord[i++] = shuffledIndex;
                        }
                        endOfN = j;
                        hash = 0;
                        for (i = 0; i < this.n; i++) {
                            if (coeff[codeWord[i]] > 0) {
                                extractedBit = coeff[codeWord[i]] & 1;
                            } else {
                                extractedBit = 1 - (coeff[codeWord[i]] & 1);
                            }
                            if (extractedBit == 1) {
                                hash ^= i + 1;
                            }
                        }
                        i = hash ^ kBitsToEmbed;
                        if (i == 0) {
                            break; // embedded without change
                        }
                        i--;
                        if (coeff[codeWord[i]] > 0) {
                            goodCoeffs.add(codeWord[i]);
                            coeff[codeWord[i]]--;
                        } else {
                            goodCoeffs.add(codeWord[i]);
                            coeff[codeWord[i]]++;
                        }
                        _changed++;
                        if (coeff[codeWord[i]] == 0) {
                            goodCoeffs.remove(goodCoeffs.size() - 1);
                            _thrown++;
                        }
                    } while (coeff[codeWord[i]] == 0);
                    startOfN = endOfN;
                } while (!isLastByte);
            } else { // default code
                // The main embedding loop follows. It works on the
                // shuffled stream of coefficients.
                for (i = 0; i < coeffCount; i++) {
                    shuffledIndex = permutation.getShuffled(i);
                    if (shuffledIndex % 64 == 0) {
                        continue; // skip DC coefficients
                    }
                    if (coeff[shuffledIndex] == 0) {
                        continue; // skip zeroes
                    }
                    _examined++;
                    if (coeff[shuffledIndex] > 0) {
                        //goodCoeffs.add(shuffledIndex);
                        if ((coeff[shuffledIndex] & 1) != nextBitToEmbed) {
                            coeff[shuffledIndex]--; // decrease absolute value
                            _changed++;
                        }
                    } else {
                        //goodCoeffs.add(shuffledIndex);
                        if ((coeff[shuffledIndex] & 1) == nextBitToEmbed) {
                            coeff[shuffledIndex]++; // decrease absolute value
                            _changed++;
                        }
                    }
                    if (coeff[shuffledIndex] != 0) {
                        goodCoeffs.add(shuffledIndex);
                        // The coefficient is still nonzero. We
                        // successfully embedded "nextBitToEmbed".
                        // We will read a new bit to embed now.
                        if (availableBitsToEmbed == 0) {
                            // If the byte of embedded text is
                            // empty, we will get a new one.
                            try {
                                if (this.embeddedData.available() == 0) {
                                    break;
                                }
                                byteToEmbed = this.embeddedData.read();
                                byteToEmbed ^= random.getNextByte();
                            } catch (final Exception e) {
                                e.printStackTrace();
                                break;
                            }
                            availableBitsToEmbed = 8;
                        }
                        nextBitToEmbed = byteToEmbed & 1;
                        byteToEmbed >>= 1;
                        availableBitsToEmbed--;
                        _embedded++;
                    } else {
                        _thrown++;
                    }
                }
            }
            if (_examined > 0) {
                Log.d(Jpeg.LOG, _examined + " coefficients examined");
            }
            Log.d(Jpeg.LOG, _changed + " coefficients changed (efficiency: " + _embedded / _changed + "."
                    + _embedded * 10 / _changed % 10 + " bits per change)");
            Log.d(Jpeg.LOG, _thrown + " coefficients thrown (zeroed)");
            Log.d(Jpeg.LOG, _embedded + " bits (" + _embedded / 8 + " bytes) embedded");

            Log.d(Jpeg.LOG, String.format("goodCoeffs length: %d", goodCoeffs.size()));
        }
    }

    public void extract (int coeff[],  ByteArrayOutputStream fos, Extract.ExtractionListener listener) {

        Log.d(Jpeg.LOG, "Permutation starts");

        ArrayList<Integer> goodCoeffs = new ArrayList<Integer>(0);

        final F5Random random = new F5Random();
        final Permutation permutation = new Permutation(coeff.length, random);

        Log.d(Jpeg.LOG, coeff.length + " indices shuffled");
        int extractedByte = 0;
        int availableExtractedBits = 0;
        int extractedFileLength = 0;
        int nBytesExtracted = 0;
        int shuffledIndex = 0;
        int extractedBit;
        int i;

        Log.d(Jpeg.LOG, "Extraction starts");
        // extract length information


        for (i = 0; availableExtractedBits < 32; i++) {
            shuffledIndex = permutation.getShuffled(i);
            if (shuffledIndex % 64 == 0) {
                continue; // skip DC coefficients
            }
            shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64];
            if (coeff[shuffledIndex] == 0) {
                continue; // skip zeroes
            }
            if (coeff[shuffledIndex] > 0) {
                goodCoeffs.add(shuffledIndex);

                extractedBit = coeff[shuffledIndex] & 1;
            } else {
                goodCoeffs.add(shuffledIndex);

                extractedBit = 1 - (coeff[shuffledIndex] & 1);
            }
            extractedFileLength |= extractedBit << availableExtractedBits++;
        }
        // remove pseudo random pad
        extractedFileLength ^= random.getNextByte();
        extractedFileLength ^= random.getNextByte() << 8;
        extractedFileLength ^= random.getNextByte() << 16;
        extractedFileLength ^= random.getNextByte() << 24;
        int k = extractedFileLength >> 24;
        k %= 32;
        final int n = (1 << k) - 1;
        extractedFileLength &= 0x007fffff;

        Log.d(Jpeg.LOG, "Length of embedded file: " + extractedFileLength + " bytes");
        availableExtractedBits = 0;
        if (n > 0) {
            int startOfN = i;
            int hash;

            Log.d(Jpeg.LOG, "(1, " + n + ", " + k + ") code used");
            extractingLoop: do {
                // 1. read n places, and calculate k bits
                hash = 0;
                int code = 1;
                for (i = 0; code <= n; i++) {
                    // check for pending end of coeff
                    if (startOfN + i >= coeff.length) {
                        break extractingLoop;
                    }
                    shuffledIndex = permutation.getShuffled(startOfN + i);
                    if (shuffledIndex % 64 == 0) {
                        continue; // skip DC coefficients
                    }
                    shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64];
                    if (coeff[shuffledIndex] == 0) {
                        continue; // skip zeroes
                    }

                    if (coeff[shuffledIndex] > 0) {
                        goodCoeffs.add(shuffledIndex);

                        extractedBit = coeff[shuffledIndex] & 1;
                    } else {
                        goodCoeffs.add(shuffledIndex);

                        extractedBit = 1 - (coeff[shuffledIndex] & 1);
                    }
                    if (extractedBit == 1) {
                        hash ^= code;
                    }
                    code++;
                }
                startOfN += i;
                // 2. write k bits bytewise
                for (i = 0; i < k; i++) {
                    extractedByte |= (hash >> i & 1) << availableExtractedBits++;
                    if (availableExtractedBits == 8) {
                        // remove pseudo random pad
                        extractedByte ^= random.getNextByte();
                        fos.write((byte) extractedByte);
                        extractedByte = 0;
                        availableExtractedBits = 0;
                        nBytesExtracted++;
                        // check for pending end of embedded data
                        if (nBytesExtracted == extractedFileLength) {
                            break extractingLoop;
                        }
                    }
                }
            } while (true);
        } else {
            Log.d(Jpeg.LOG, "Default code used");
            for (; i < coeff.length; i++) {
                shuffledIndex = permutation.getShuffled(i);
                if (shuffledIndex % 64 == 0) {
                    continue; // skip DC coefficients
                }
                shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64];
                if (coeff[shuffledIndex] == 0) {
                    continue; // skip zeroes
                }
                if (coeff[shuffledIndex] > 0) {
                    extractedBit = coeff[shuffledIndex] & 1;
                } else {
                    extractedBit = 1 - (coeff[shuffledIndex] & 1);
                }
                extractedByte |= extractedBit << availableExtractedBits++;
                if (availableExtractedBits == 8) {
                    // remove pseudo random pad
                    extractedByte ^= random.getNextByte();
                    fos.write((byte) extractedByte);
                    extractedByte = 0;
                    availableExtractedBits = 0;
                    nBytesExtracted++;
                    if (nBytesExtracted == extractedFileLength) {
                        break;
                    }
                }
            }
        }

        if (nBytesExtracted < extractedFileLength) {
            Log.d(Jpeg.LOG, "Incomplete file: only " + nBytesExtracted + " of " + extractedFileLength
                    + " bytes extracted");
        } else {
            //((ExtractionListener) a).onExtractionResult(fos);
            Log.d(Jpeg.LOG, String.valueOf(fos));
            // OLD VERSION: this.listener.onExtractionResult(fos);
            listener.onExtractionResult(fos);
        }
    }

}
