package daggm.demo.server;

import java.util.HashSet;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

import daggm.demo.actions.LoginUserAction;
import daggm.demo.actions.RegisterUserAction;
import daggm.demo.actions.ValidateLoginName;
import daggm.demo.client.GreetingService;
import daggm.demo.data.User;
import dataApp2GWTGuiMapper.actions.ActionRepository;
import dataApp2GWTGuiMapper.data.FormRepositoryItem;
import dataApp2GWTGuiMapper.data.FormsRepository;
import dataApp2GWTGuiMapper.metadataAnnotation.MetaDataHelper;
import dataApp2GWTGuiMapper.metadataAnnotation.Register;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class GreetingServiceImpl extends RemoteServiceServlet implements
		GreetingService {

	public String greetServer(String[] input) throws IllegalArgumentException {
		if (input[0].startsWith("LOGINFP")) {
			Register theReg = new Register();
	        theReg.registerObject(User.class);
	        MetaDataHelper theMDataHelper = new MetaDataHelper();
	        theMDataHelper.buildFormsMetadata(theReg);
	        FormRepositoryItem theItem = new FormRepositoryItem();
	        HashSet<Object> theSet = new HashSet<Object>();
	        User theEditor = new User();
	        theSet.add(theEditor);
	        theItem.setDataObjects(theSet);
	        theItem.setMetadata(theMDataHelper.getFormMetadata("loginPanel"));
	        FormsRepository.getInstance().registerForm(input[0], theItem);
		}
		if (input[1].startsWith("REGISTERFP")) {
			Register theReg = new Register();
	        theReg.registerObject(User.class);
	        MetaDataHelper theMDataHelper = new MetaDataHelper();
	        theMDataHelper.buildFormsMetadata(theReg);
	        FormRepositoryItem theItem = new FormRepositoryItem();
	        HashSet<Object> theSet = new HashSet<Object>();
	        User theEditor = new User();
	        theSet.add(theEditor);
	        theItem.setDataObjects(theSet);
	        theItem.setMetadata(theMDataHelper.getFormMetadata("registerPanel"));
	        FormsRepository.getInstance().registerForm(input[1], theItem);
		}
		ActionRepository.getInstance().registerAction("RegisterUser", new RegisterUserAction());
		ActionRepository.getInstance().registerAction("LoginUser", new LoginUserAction());
		ActionRepository.getInstance().registerAction("ValidateLogin", new ValidateLoginName());
        return "";
	}
}
