package dataApp2GWTGuiMapper.actions;

import java.util.HashMap;
import java.util.Map;

public class ActionRepository {

    private ActionRepository() {
    }

    private static final ActionRepository sharedInstance = new ActionRepository();

    public static ActionRepository getInstance() {
        return sharedInstance;
    }

    private Map<String, IAction> repository;

    public void registerAction(String anId, IAction anAction) {
        if (repository == null) {
            repository = new HashMap<String, IAction>();
        }
        repository.put(anId, anAction);
    }

    public Map<String, IAction> getRegisteredItems() {
        return repository;
    }

    public IAction getItem4Id(String anId) {
        if (repository != null) {
            return repository.get(anId);
        }
        return null;
    }
	
}
