/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package dataApp2GWTGuiMapper.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class helps with reflections.
 * @author mildo
 */
public class ReflectHelper
    implements ReflectionDefs
{

    public static Object getFieldValue(Object anObject, String aMethodName) {
        Object ret = null;
        Method theMethod = null;
        Exception theEx = null;
        for (String aPrefix : GETTERS_PREFIXES) {
            try {
                theMethod = anObject.getClass().getMethod(aPrefix + aMethodName);
            } catch (NoSuchMethodException ex) {
            	theEx = ex;
            } catch (SecurityException ex) {
            	theEx = ex;
            }
        }
        if (theMethod != null) {
            try {
                ret = theMethod.invoke(anObject);
            } catch (IllegalAccessException ex) {
                Logger.getLogger(ReflectHelper.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IllegalArgumentException ex) {
                Logger.getLogger(ReflectHelper.class.getName()).log(Level.SEVERE, null, ex);
            } catch (InvocationTargetException ex) {
                Logger.getLogger(ReflectHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
        	Logger.getLogger(ReflectHelper.class.getName()).log(Level.SEVERE, null, theEx);
        }
        return ret;
    }

    public static boolean setFieldValue(Object anObject, String aMethodName, Object aValue) {
        boolean ret = false;
        Method theMethod = null;
        Exception theEx = null;
        for (String aPrefix : SETTERS_PREFIXES) {
            try {
                theMethod = anObject.getClass().getMethod(aPrefix + aMethodName, aValue.getClass());
            } catch (NoSuchMethodException ex) {
            	theEx = ex;
            } catch (SecurityException ex) {
            	theEx = ex;
            }
        }
        if (theMethod != null) {
            try {
                theMethod.invoke(anObject, aValue);
                ret = true;
            } catch (IllegalAccessException ex) {
            	theEx = ex;
            } catch (IllegalArgumentException ex) {
            	theEx = ex;
            } catch (InvocationTargetException ex) {
            	theEx = ex;
            }
        }
        if (!ret) {
        	Logger.getLogger(ReflectHelper.class.getName()).log(Level.SEVERE, null, theEx);
        }
        return ret;
    }

    public static Object getInstanceOf(Set<Object> anObjects, String aClassName) throws ClassNotFoundException {
        Object ret = null;
        Class theClass = Class.forName(aClassName);
        for (Object theObject : anObjects) {
            if (theObject.getClass().equals(theClass)) {
                ret = theObject;
            }
        }
        return ret;
    }

}
