package dataApp2GWTGuiMapper.services.server.validateForm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

import dataApp2GWTGuiMapper.data.FormData;
import dataApp2GWTGuiMapper.data.FormRepositoryItem;
import dataApp2GWTGuiMapper.data.FormsRepository;
import dataApp2GWTGuiMapper.data.ValidationDataResult;
import dataApp2GWTGuiMapper.data.WidgetData;
import dataApp2GWTGuiMapper.metadata.ValidationMetadata;
import dataApp2GWTGuiMapper.metadata.WidgetMetadata;
import dataApp2GWTGuiMapper.services.client.validateForm.ValidateFormService;
import dataApp2GWTGuiMapper.validation.IValidation;

@SuppressWarnings("serial")
public class ValidateFormServiceImpl extends RemoteServiceServlet implements 
	ValidateFormService {

	@SuppressWarnings("unchecked")
	public ValidationDataResult[] validateData(FormData aData) {
		LinkedList<ValidationDataResult> theRes = new LinkedList<ValidationDataResult>();
		FormRepositoryItem theItem = FormsRepository.getInstance().getItem4Id(aData.getFormId());
		Iterator<WidgetMetadata> theIter = theItem.getMetadata().getWidgets().iterator();
		while (theIter.hasNext()) {
			WidgetMetadata theWMetaData = theIter.next();
			Iterator<ValidationMetadata> theValidIter = theWMetaData.getValidationMetadata().iterator();
			while (theValidIter.hasNext()) {
				ValidationMetadata theVMetaData = theValidIter.next();
				try {
					Class theValidationClass = Class.forName(theVMetaData.getValidationClassName());
					IValidation theValClass = (IValidation)theValidationClass.newInstance();
					HashMap<String, String> theParams = new HashMap<String, String>();
					for (int i = 0; i < theVMetaData.getValidationKeys().length; i++) {
						theParams.put(theVMetaData.getValidationKeys()[i], theVMetaData.getValidationValues()[i]);
					}
					WidgetData theData = aData.getWidget(theWMetaData.getName());
					if (theData != null) {
						ValidationDataResult theValRes = new ValidationDataResult();
						theValRes.setValidationClassName(theVMetaData.getValidationClassName());
						theValRes.setWidgetName(theWMetaData.getName());
						theValRes.setWasSucessfull(theValClass.validate(theData.getData(), theParams));
						theRes.add(theValRes);
					}
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				} catch (InstantiationException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				}
			}
		}
		ValidationDataResult[] ret = new ValidationDataResult[theRes.size()];
		for (int i = 0; i < theRes.size(); i++) {
			ret[i] = theRes.get(i);
		}
		return ret;
	}

}
