#!/usr/bin/python
# encoding: utf8
from __future__ import print_function, division
from rules import GridFillingRules
from grid import Grid, val_to_output
import game
import main
import postscript
import math
import random

class ChaosRules(GridFillingRules):
    def __init__(self, game):
	self.game = game

    def consecutive_3_most_2(self, dest):
	term = self.game.term
	width, height = self.game.width, self.game.height
	for x in range(width):
	    for y in range(height):
		for n in range(self.game.colors):
		    for dx, dy in [(0,1), (1,0), (1,1), (-1,1)]:
			if 0 <= x+2*dx < width and 0 <= y+2*dy < height:
			    dest.append([-term(x+d*dx, y+d*dy, n) for d in range(3)])

    def knight(self, dest):
	term = self.game.term
	width, height = self.game.width, self.game.height
	for x in range(width):
	    for y in range(height):
		for n in range(self.game.colors):
		    for dx, dy in [(-1,2),(-2,1),(1,2),(2,1)]:
			if 0 <= x+dx < width and 0 <= y+dy < height:
			    dest.append((-term(x, y, n), -term(x+dx, y+dy, n)))


    rule_list = GridFillingRules.rule_list + [consecutive_3_most_2, knight]

class ChaosGrid(Grid):
    def as_eps(self):
	data = self.data
	w, h = self.game.width, self.game.height
	c = 47
	eps = postscript.EPS(-0.05 * c, -0.05 * c, (w+0.1)*c, (h+0.1)*c)
	eps.scale(c, c)
	# grid
	eps.setlinewidth(0.05)
	eps.rectangle(0, 0, w, h)
	eps.setlinewidth(0.02)
	for x in range(1, w):
	    eps.line(x, 0, 0, h)
	for y in range(1, h):
	    eps.line(0, y, w, 0)
	# prefilled numbers
	eps.setfont("Helvetica", 1)
	eps.translate(0.25, 0.16)
	for x in range(w):
	    for y in range(h):
		if data[x][y] is not None:
		    eps.text(x, y, val_to_output(data[x][y], ' '))
	return eps.as_string()

class Chaos(game.GridFillingGame):
    colors = 4
    name = "chaos"
    grid_class = ChaosGrid
    output_formatter = { "draw": grid_class.as_ascii,
			 "dot": grid_class.as_dot,
			 "eps": grid_class.as_eps }

    def __init__(self, opts):
	self.width = opts.width if opts.width else 7
	self.height = opts.height if opts.height else self.width
	super(Chaos, self)._init(self)
	self.baseterms = self.nterms
	self.rules = ChaosRules(self)

    def initial_random(self):
	res = []
	for i in range(int(math.sqrt(self.width * self.height))):
	    res.append([(random.randrange(self.baseterms)+1)])
	return res


if __name__ == "__main__":
    main.main(Chaos)
