from __future__ import print_function, division
import os
import shared


def _clause_to_string(clause):
    if clause is None:
	return "1 -1 0"
    return " ".join(str(x) for x in clause) + " 0"

class cnf(object):
    """Easy (and fast?) handling of CNF (DIMACS) format files"""

    def __enter__(self):
	return self

    def __exit__(self, *whatever):
	if not self.keep:
	    os.remove(self.file.name)
	self.file.close()

    def __init__(self, name, variables = 0, min_slack = 6, keep = False):
	self.filename = shared.temp_prefix(name) + ".cnf"
	self.file = open(self.filename, "w")
	self.file.seek(0)
	self.variables = variables
	self.clauses = []
	print("p cnf", int(variables), 30 * " ", file=self.file)
	self.lines = [self.file.tell()]
	self.min_slack = min_slack
	self.keep = keep

    def __getitem__(self, key):
	return self.clauses.__getitem__(key)

    def __iter__(self):
	return self.clauses.__iter__()

    def __len__(self):
	return len(self.clauses)

    def append(self, clause, in_place = False):
	self.clauses.append(clause)
	s = _clause_to_string(clause)
	if not in_place:
	    self.file.seek(self.lines[-1])
	print(s, (self.min_slack - len(s)) * " ", sep="", file=self.file)
	self.lines.append(self.file.tell())

    def extend(self, list):
	end = self.lines[-1]
	self.file.seek(end)
	min_slack = self.min_slack
	file, lines = self.file, self.lines
	self.clauses.extend(list)
	for clause in list:
	    if clause is None:
		s = "1 -1 0"
	    else:
		s = " ".join([str(x) for x in clause] + ["0"])
	    if len(s) < min_slack:
		s += (min_slack - len(s)) * " "
	    s += "\n"
	    file.write(s)
	    end += len(s)
	    lines.append(end)


    def __setitem__(self, key, value):
	s = _clause_to_string(value)
	lines = self.lines
	self.file.seek(lines[key])
	if not (0 <= key < len(lines) - 1):
	    raise Exception("Bad key")
	spaces = lines[key + 1] - lines[key] - len(s) - 1
	if spaces < 0:
	    print(s)
	    raise Exception("not enough slack space for __setitem__")
	print(s, spaces * " ", sep="", file=self.file)
	self.clauses[key] = value
	assert(self.file.tell() == lines[key+1])


    def pop(self):
	self.file.truncate(self.lines[-2])
	self.lines.pop()
	return self.clauses.pop()

    def truncate(self, count):
	if count <= len(self.clauses):
	    self.file.truncate(self.lines[count])
	self.lines[count+1:] = []
	self.clauses[count:] = []
	
    def flush(self):
	self.file.seek(0)
	print("p cnf", int(self.variables), len(self.clauses),
	    end="\nc", file=self.file)
	self.file.flush()
