from __future__ import print_function, division
import random
import sys
from shared import print_v

def genstat(solutions, limit):
    stats = [0 for x in range(limit+1)]
    for sol in solutions:
	for x in sol:
	    if x < limit+1:
		stats[x] += 1
    return stats

def minimize(rules, sat, constraints):
    base_count = len(rules)
    rules.extend(constraints)
    for i in range(len(rules) - 1, base_count - 1, -1): #[start, end) in reverse
	t = rules[i]
	rules[i] = None
	sols = sat.run(rules, 2)
	if sols.sat == "SAT" and sols.count == 1:
	    print_v("removing")
	else:
	    rules[i] = t
	    print_v("keeping:", "needed" if sols.sat == "SAT" else sols.sat)
    needed = [x for x in rules[base_count:] if x is not None]
    rules.truncate(base_count)
    return needed

def verify(rules, sat, constraints):
    base_count = len(rules)
    rules.extend(constraints)
    timeout = sat.timeout
    if sat.timeout:
	sat.timeout *= 2
    sols = sat.run(rules, 2)
    sat.timeout = timeout
    rules.truncate(base_count)
    if sols.sat == "SAT" and sols.count == 1:
	print_v("OK, exactly 1 solution")
	return True
    elif sols.sat == "TIMEOUT":
	print_v("Timed out while verifying")
	return None
    else:
	print("wtf? sat=", sols.sat, "count=", sols.count)
	sols.dump()
	return False

def solve(rules, sat, constraints):
    base_count = len(rules)
    rules.extend(constraints)
    sols = sat.run(rules, 2)
    rules.truncate(base_count)
    if sols.sat == "SAT":
	return map(lambda x: (x,), sols.solutions[0])
    elif sols.sat == "TIMEOUT":
	print_v("Timed out while solving")
	return None
    else:
	print("wtf? sat=", sols.sat, "count=", sols.count)
	sols.dump()
	return False


class Strategy(object):
    solution_count = 2

    def generate(self, game, rules, sat):
	known_good = len(rules)
	base_count = len(rules)
	rand = game.initial_random()
	rules.extend(rand)

	tried = set(map(tuple, rand))

	while True:
	    print_v("extra rules:", len(rules) - base_count, end=" ")
	    sols = sat.run(rules, self.solution_count, None, self.need_sols)
	    solutions = sols.solutions
	    print_v("sol =", sols.count, sols.sat)
	    if sols.sat == "SAT" and sols.count == 1:
		break
	    if sols.sat != "SAT":
		rules.pop()
	    elif sols.sat == "SAT":
		known_good = len(rules)
	    if len(rules) == known_good and (not self.need_sols or solutions != []):
		while True:
		    print_v(".", end='')
		    term = self.pick_term(solutions, game.baseterms)
		    newrule = tuple(game.rule(term))
		    if newrule not in tried:
			break
		tried.add(newrule)
		rules.append(newrule)

	assert(sols.sat == "SAT" and sols.count == 1)

	res = rules[base_count:]
	rules.truncate(base_count)
	return res


class SolverStrategy(Strategy):
    need_sols = True
    solution_count = 3

    def pick_term(self, solutions, limit):
	stats = genstat(solutions, limit)
	candidates = self.candidates(solutions, stats, limit)
	return random.choice(candidates)

class LeastCommonStrategy(SolverStrategy):
    def candidates(self, solutions, stats, limit):
	t = min(filter(lambda x: x > 0, stats))
	return [i for (i, x) in enumerate(stats) if x == t]

class FirstStrategy(SolverStrategy):
    def candidates(self, solutions, stats, limit):
	mx = max(stats)
	return [x for x in solutions[0] if x < limit and stats[x] < max]

class LastStrategy(SolverStrategy):
    def candidates(self, solutions, stats, limit):
	mx = max(stats)
	return [x for x in solutions[-1] if x < limit and stats[x] < max]

class RandomStrategy(Strategy):
    need_sols = False

    def pick_term(self, solutions, limit):
	return random.randrange(limit)+1

class StdinStrategy(object):
    def generate(self, game, rules, sat):
	line = sys.stdin.readline()
	line = line.lstrip(" \t%#").rstrip(" \t\n")
	grid = game.grid_class(game).set_from_dot(line)
	return grid.as_terms()

strategies = {"least": LeastCommonStrategy, "random": RandomStrategy,
    "first": FirstStrategy, "last": LastStrategy, "stdin": StdinStrategy }

