from __future__ import print_function, division

class Game(object):
    default_strategy = "least"
    default_solver = "picosat"
    dont_minimize_when_solving = False

    def initial_random(self):
	return []

    def rule(self, term):
	return [term]

class GridFillingGame(Game):
    """Generic info and support functions for a grid
    filling game. Each of "width" * "height" cells has
    one of "color" colors."""

    dont_minimize_when_solving = True

    def _init(self, opts):
	self.nterms = self.colors * self.height * self.width

    def term(self, x, y, col):
	"""Convert coodinates and number to propositinal term id.

	Returns the (index of) propositional term grid[x][y] == col.
	x,y,num are 0-based
	Terms are 1-based"""
	return ((x * self.height + y) * self.colors) + col + 1

    def decomp(self, term):
	term -= 1
	term, n = divmod(term, self.colors)
	term, y = divmod(term, self.height)
	x = term
	return x, y, n

class GridCrossingGame(Game):
    """Generic info and support functions for a grid
    crossing game. Each of ("width" - 1) * ("height" -1 ) * 2
    crossings can be selected, or not."""

    dirs = [(1,0), (0,1), (-1,0), (0,-1)]

    def _init(self, opts):
	w, h = self.width, self.height
	self._line = w + w - 1
	self.nterms = 2 * w * h - w - h
	self.crossingterms = self.nterms

    def term(self, x, y, dir):
	if dir > 1:
	    x += self.dirs[dir][0]
	    y += self.dirs[dir][1]
	    dir -= 2
	res = y * self._line + dir * (self.width - 1) + x + 1
	if (x < 0) or (y < 0) or (res > self.crossingterms) or (x + 1 >= self.width + dir):
	    return None
	return res

    def decomp(self, term):
	term -= 1
	y, term = term // self._line, term % self._line
	dir = 1 if term // (self.width - 1) else 0
	x = term - dir * (self.width - 1)
	return x, y, dir

