# encoding: utf8
from __future__ import print_function, division

class EPS(object):
    header = ["gsave",
	      "/text {newpath moveto show} def",
	      "/line {newpath moveto rlineto stroke} def"]
    trailer = ["grestore"]

    def __init__(self, x, y, width, heigth):
	self.data = []
	self.bbox = "{0} {1} {2} {3}".format(x, y, x+width, y+heigth)

    def setlinewidth(self, w):
	self.data.append("{0} setlinewidth".format(w))

    def setlinecap(self, i):
	self.data.append("{0} setlinecap".format(i))

    def setgray(self, g):
	self.data.append("{0} setgray".format(g))

    def setfont(self, name, size):
	self.data.append("/{0} findfont {1} scalefont setfont".format(name, size))

    def translate(self, dx, dy):
	self.data.append("{0} {1} translate".format(dx, dy))

    def scale(self, x, y):
	self.data.append("{0} {1} scale".format(x, y))

    def newpath(self):
	self.data.append("newpath")

    def moveto(self, x, y):
	self.data.append("{0} {1} moveto".format(x, y))

    def rlineto(self, x, y):
	self.data.append("{0} {1} rlineto".format(x,y))

    def closepath(self):
	self.data.append("closepath")

    def stroke(self):
	self.data.append("stroke")

    def show(self, text):
	self.data.append("({0}) show".format(text))

    def line(self, x, y, dx, dy):
	self.data.append("{2} {3} {0} {1} line".format(x, y, dx, dy))

    def rectangle(self, x, y, w, h):
	self.newpath()
	self.moveto(x, y)
	self.rlineto(w, 0)
	self.rlineto(0, h)
	self.rlineto(-w, 0)
	self.closepath()
	self.stroke()

    def text(self, x, y, text):
	self.data.append("({2}) {0} {1} text".format(x, y, text))

    def as_string(self):
	return '\n'.join(["%!PS-Adobe-3.0 EPSF-3.0", "%%BoundingBox: " + self.bbox]
		+ self.header + self.data + self.trailer)
