﻿<?php

	class menuItem
	{
		public $label;
		public $urlParams;
		public $bExpanded;
		public $bSelected;
		public $items;
    
		function __construct( $label, $urlParams )
		{
			$this->label = $label;
			$this->urlParams = $urlParams; 
			$this->bExpanded = false;
			$this->bSelected = false;
			$this->items = array();
		}
		
		function AddItem( $label, $urlParams )
		{
			$count = count($this->items);
			$this->items[$count] = new menuItem( $label, $urlParams );
			return $this->items[$count];  
		}
		
		function GetItemByLabel( $label )
		{
			for ( $i = 0; $i < count($this->items); $i++ )
			{
				if ( $this->items[$i]->label === $label ) return $this->items[$i];
			}
			return NULL;
		}
	
		function GetItemByIndex( $index )
		{
			if ( $index < count($this->items) ) return $this->items[$index];			  
			return NULL;
		}
	}
  
	class menu
	{
		public $items;
		protected $db;  
    
		function __construct($db)
		{
			$this->items = array();
			$this->db = $db; 
		}
		
		function AddItem( $label, $urlParams )
		{
			$count = count($this->items);
			$this->items[$count] = new menuItem( $label, $urlParams );
			return $this->items[$count];  
		}
    
   
		function GetItemByLabel( $label )
		{
			for ( $i = 0; $i < count($this->items); $i++ )
			{
				if ( $this->items[$i]->label === $label ) return $this->items[$i];
			}
			return NULL;
		}

		function GetItemByIndex( $index )
		{
			if ( $index < count($this->items) ) return $this->items[$index];
						  
			return NULL;
		}
    
		function GenerateMenu ($paramSuffix)
		{
			//select all pages on which the currently logged user have access to - generate menu from them
			$query = "SELECT page.PAGENAME, page.PAGELINK FROM DM_PageRights AS page WHERE (".
				"FIND_IN_SET('".$_SESSION["userGroup"][0]."',page.GROUPS)>0 OR ".
				"FIND_IN_SET('".$_SESSION["userGroup"][1]."',page.GROUPS)>0 OR ".
				"FIND_IN_SET('".$_SESSION["userGroup"][2]."',page.GROUPS)>0 OR ".
				"FIND_IN_SET('".$_SESSION["userGroup"][3]."',page.GROUPS)>0 OR ".
				"FIND_IN_SET('".$_SESSION["userGroup"][4]."',page.GROUPS)>0 OR ".
				"FIND_IN_SET('".$_SESSION["userGroup"][5]."',page.GROUPS)>0 )".
				" AND page.MENU_ITEM = '1' ".
				"ORDER BY page.POSITION ASC;";
			$result = $this->db->QueryToArray($query);
			if ( $result != 0 )
			{
				foreach($result as $key=>$value)
				{
					$this->AddItem($value["PAGENAME"], $value["PAGELINK"].$paramSuffix);
				}
			}  
		}
  	}
?>