<?php

class CategoryList extends Top
{
	private $aData = array();
	private $sCatListHTMLcode = "";
	private $sCatListLeftHTMLcode = "";
	private $sCatListRightHTMLcode = "";

	private $iActualPage = 1;
	private $iRowsPerPage = 50;
	private $iRowCount;

	private $sOrderBy = "c.id ASC";
	private $sWhere = "";
	private $iParentId = 0;

	
	public function Show()
	{
		$this->Build();

		if($this->bIsAdmin==true){

			$params = array('source'=>"category_list");
			$search = $this->roTemplate->ParseRow("search.tpl", $params);

			$params = array(
			'rows'=>$this->sCatListHTMLcode,
			'pages'=>$this->Paging(),
			'search'=>$search,
			);

		} else {

			$params = array(
			'rows_left'=>$this->sCatListLeftHTMLcode,
			'rows_right'=>$this->sCatListRightHTMLcode,
			'pages'=>$this->Paging(),
			);

		}

		$this->roTemplate->AddContent("category_list.tpl", $params);

		return true;
	}
	

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}


	public function SetCriteria($const, $parent_id=0, $letter=null){

		switch ($const){
			case "PARENT":
				$this->iParentId = $parent_id;
				//$this->sWhere = "WHERE parent_id=$parent_id";
				break;
			case "HOME":
				$this->sOrderBy = "c.id ASC";
				$this->iRowsPerPage = 5;
				break;
			case "LETTER":
				//$this->sWhere = "AND name_idx like 'category_$letter%'";
				break;
		}

	}

	public function DeleteCategory($id)
	{
		$category = new Category($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng, $id);
		$category->DeleteData();
	}


	public function Load()
	{
		$from = $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage;

		$sql_from = "";
		$sql_where = "";
		$time = time();

		if($this->bIsAdmin==true){
			$sql_from = TBL_CATEGORIES." AS c";
		} else {
			$sql_from = TBL_CATEGORIES." AS c, ".TBL_CATEGORIES_HAS_PRODUCTS." AS chp,".TBL_PRODUCTS." AS pt";
			$sql_where = "AND c.id=chp.categories_id AND pt.id=chp.products_id AND pt.released_date<$time AND pt.active=1";
		}

		$query = "  SELECT count(DISTINCT c.id)
                    FROM $sql_from
                    WHERE 1=1
                    $sql_where
                    $this->sWhere
                ";
		$this->iRowCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "  SELECT DISTINCT c.id, c.parent_id, c.has_img, c.discount
                    FROM $sql_from
                    WHERE 1=1
                    $sql_where
                    $this->sWhere
                    ORDER BY $this->sOrderBy
                    LIMIT $from , $this->iRowsPerPage
                ";
		$this->aData = $this->roDB->GetArray($query);
		if ($this->roDB->GetLastErrorMsg() || (!is_array($this->aData))){
			return false;
		} else {
			return true;
		}
	}



	private function Build()
	{
		if (!$this->Load()){
			$params = array('err_message'=>$this->aLng['error_loading_list']);
			$this->sCatListHTMLcode = $this->roTemplate->parseRow("error.tpl",$params);
			return false;
		}

		$has_category = array();
		foreach($this->aData as $row){

			list($id, $parent_id, $has_img, $discount) = $row;

			if($parent_id!=$this->iParentId){
				$has_category[]=$parent_id;
			}
		}

		$time = time();
		$counter = 1;
		$half = ceil($this->iRowCount/2);

		foreach($this->aData as $row)
		{
			list($id, $parent_id, $has_img, $discount) = $row;
			$category_name = $this->aLng['category_'.$id];
			$category_name = $discount ? $category_name." (".($discount/100)."%)" : $category_name;
			
			$query = "SELECT count(x.products_id) FROM ".TBL_CATEGORIES_HAS_PRODUCTS." AS x,".TBL_PRODUCTS." AS p WHERE p.id=x.products_id AND x.categories_id=$id AND p.released_date<$time AND p.active=1";
			$product_count = $this->roDB->GetOne($query);
			if ($this->roDB->GetLastErrorMsg()){
				return false;
			}


			if($this->bIsAdmin==true){

				if($parent_id!=$this->iParentId){
					continue;
				}
				
				if(in_array($id, $has_category)){
					$params = array(
					'link'=>"category_list.php?parent=".$id,
					'name'=>$category_name
					);
					$category_name = $this->roTemplate->parseRow("link.tpl",$params);
				}			

				$params = array(
				'id'=>$id,
				'parent_id'=>$parent_id,
				'category_name'=>$category_name,
				'has_img'=>$has_img,
				'product_count'=>$product_count
				);

				$this->sCatListHTMLcode .= $this->roTemplate->parseRow("category_list_row.tpl",$params);

			} else {

				$params = array(
				'category_name'=>$category_name,
				'product_count'=>$product_count,
				);

				$category_list_row =  $this->roTemplate->parseRow("category_list_row.tpl",$params);

				if($product_count>0){

					$params = array(
					'path'=>"category.php?id=".$id,
					'name'=>$category_list_row,
					);

					if($counter>$half){
						$this->sCatListRightHTMLcode .= $this->roTemplate->parseRow("cols_list.tpl",$params);
					} else {
						$this->sCatListLeftHTMLcode .= $this->roTemplate->parseRow("cols_list.tpl",$params);
					}

				}

				$counter++;
			}
		}

		return true;
	}

	private function Paging($source="category_list")
	{
		$paging = "";
		$amp = "";
		$page_count = ceil($this->iRowCount / $this->iRowsPerPage);

		if($this->iActualPage>1){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1)
		{
			$_paging_count_pages_half = floor(PAGING_COUNT_PAGES / 2);

			$_page_start = max(1, min($this->iActualPage, $page_count - $_paging_count_pages_half) - $_paging_count_pages_half);
			$_page_stop = min(max($this->iActualPage, $_paging_count_pages_half) + $_paging_count_pages_half, $page_count);

			for($i=$_page_start; $i<=$_page_stop; $i++)
			{
				if($this->iActualPage==$i) {
					$params = array(
					'page_number'=>$i,
					);
					$paging .= $this->roTemplate->parseRow("paging_actual.tpl",$params);
				} else {
					$params = array(
					'source'=>$source,
					'page_number'=>$i,
					'page_name'=>$i,
					'amp'=>$amp
					);
					$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
				}  
				$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		return $paging;
	}

	public function GetData(){
		return $this->aData;
	}

}

?>
