<?php


class Home extends Top
{
	private $aData = array();
	private $iActualPage = 1;
	private $sOrderBy;

	public function __construct($db_object, $template_object, $lang_array, $used_lang_array)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array);
		$this->bIsPrivate = (isset($_SESSION['user_id']) && is_numeric($_SESSION['user_id'])) ? true : false;
	}


	public function Show()
	{
		$product_list = new ProductList($this->roDB, $this->roTemplate, $this->aLng,$this->aUsedLng);
		$product_list->SetCriteria("HOME");
		$product_list->SetPage($this->iActualPage);
		if($this->sOrderBy){
			$product_list->SetOrder($this->sOrderBy);
		}
		$product_list->Load();
		$this->aData = $product_list->GetData();

		list($id,$name,$producers_id,$added_date,$released_date,$price,$availability,$stock_count,$active,$is_editors_pick,$has_img,$discount) = $this->aData[0];


		if(($this->bIsPrivate)&&($stock_count>0)){
			$params = array('product_id'=>$id);
			$order = $this->roTemplate->parseRow("order_form.tpl",$params);
		} else {
			$order = "";
		}

		if($_SESSION['currency'] != DEFAULT_CURRENCY){
			$price = round($price / kurzNBS($_SESSION['currency']), 2);
		}

		$params = array(
		'name'=>$name,
		'date'=>date("d.m.Y",$released_date),
		'description'=>"",
		'availability'=>($availability==0) ? $this->aLng['standard'] : $this->aLng['premium'],
		'stock'=>$stock_count,
		'price'=>$price,
		'path'=>SERVER_URL."/product.php?id=".$id,
		'img_path'=>(is_file(IMG_PRODUCTS_DIR."/".$id."_main.jpg")) ? IMG_PRODUCTS_URL."/".$id."_main.jpg" : IMG_PRODUCTS_URL."/blank.gif",
		'order'=>$order,
		);


		$product = $this->roTemplate->parseRow("product_list_row_home.tpl",$params);

		$params = array(
		'rows'=>$product,
		);

		$this->roTemplate->AddContent("product_list_home.tpl", $params);

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetOrder($order_by)
	{
		$this->sOrderBy = $order_by;
		$this->bIsTitle = false;
	}


}
?>
