<?php


class ProductList extends Top
{
	private $aData = array();
	private $sProductListHTMLcode = "";

	private $iActualPage = 1;
	private $iRowsPerPage = 50;
	private $iRowCount;

	private $sOrderBy = "p.released_date DESC, p.name ASC";
	private $sTitle = "movies";
	private $bShowNumbers = false;
	private $bIsListEmpty = false;
	private $bShowPaging = true;
	private $bShowSorting = true;
	private $sOrder = "date";
	private $sCriteria;
	private $bIsPrivate;
	private $bIsEditors = false;
	private $sPathAdd;
	private $sSearchFor;

	private $iFilterId = 0;
	private $sFilterLetter = 0;

	public function __construct($db_object,$template_object,$lang,$used_lang, $is_admin = false)
	{
		parent::__construct($db_object,$template_object,$lang,$used_lang,$is_admin);
		$this->bIsPrivate = (isset($_SESSION['user_id']) && is_numeric($_SESSION['user_id'])) ? true : false;
	}

	public function Show()
	{
		$this->Build();

		if($this->bIsAdmin==true)
		{
			$params = array('source'=>"product_list");
			$search = $this->roTemplate->ParseRow("search.tpl", $params);

			$params = array(
			'rows'=>$this->sProductListHTMLcode,
			'pages'=>$this->Paging(),
			'search'=>$search,
			);
		} else {

			$params = array(
			'rows'=>$this->sProductListHTMLcode,
			'pages'=>$this->Paging("product_list", null, $this->sOrder, $this->sCriteria),
			'result_from'=>$this->GetResultFrom(),
			'result_to'=>$this->GetResultTo(),
			'result'=>$this->GetRowCount(),
			);
		}


		if(($this->sCriteria=="EDITORS")&&($this->bIsAdmin)){
			$this->roTemplate->AddContent("product_list_editors.tpl", $params);
		} else {
			$this->roTemplate->AddContent("product_list.tpl", $params);
		}

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetOrder($order_by)
	{
		switch ($order_by){
			case "date":
				$this->sOrderBy = "p.released_date DESC, p.name ASC";
				$this->sOrder = "date";
				break;
			case "popularity":
				$this->sOrderBy = "SUM(s.downloaded_count) DESC, v.name ASC";
				$this->sOrder = "popularity";
				break;
			case "alphabet":
				$this->sOrderBy = "p.name ASC";
				$this->sOrder = "alphabet";
				break;
		}
	}


	public function SetCriteria($const, $id=null, $letter=null)
	{
		$this->sCriteria = $const;
		$this->sCriteriaUrl = $const;
		$this->iFilterId = $id;
		$this->sFilterLetter = $letter;


		switch ($const){
			case "HOME":
				$this->iRowsPerPage = 5;
				break;
			case "NEWEST":
				$this->iRowsPerPage = 5;
				$new_date = time() - NEW_ICON_TIME;
				$this->sTitle = "newest_movies";
				$this->sPathAdd = "&newest";
				break;
			case "EDITORS":
				$this->iRowsPerPage = 5;
				$this->sTitle = "editors_pick";
				$this->sPathAdd = "&editors";
				break;
			case "CATEGORY":
				$this->iRowsPerPage = 5;
				$this->iFilterId = $id;
				$this->sPathAdd = "&category_id=$id";
				break;
			case "PRODUCER":
				$this->iRowsPerPage = 5;
				$this->iFilterId = $id;
				$this->sPathAdd = "&producer_id=$id";
				break;
			case "LETTER":
				break;
		}

	}

	public function DeleteProduct($id)
	{
		$product = new Product($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng, $id);
		$product->DeleteData();
	}

	public function UpdateEditors($id,$add=true)
	{
		$product = new Product($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng, $id);
		$value = ($add==true) ? 1 : 0;
		$product->UpdateIsEditorsPickDB($value);
	}

	public function Load()
	{
		$sql_where = "";
		$sql_from = "";

		if ($this->bIsAdmin == false)
		{
			if (!$this->sCriteria)
			$this->SetCriteria("HOME");

			$sql_where .= " AND p.released_date<".time()." AND p.active=1";
		}

		switch ($this->sCriteria){
			case "HOME":
				break;
			case "NEWEST":
				$sql_where .= " AND p.released_date>".(time() - NEW_ICON_TIME);
				break;
			case "EDITORS":
				$sql_where .= " AND p.is_editors_pick=1";
				break;
			case "CATEGORY":
				$sql_where .= " AND chp.products_id=p.id AND chp.categories_id=".$this->iFilterId;
				$sql_from .= ",".TBL_CATEGORIES_HAS_PRODUCTS." AS chp";
				break;
			case "PRODUCER":
				$sql_where .= " AND p.producers_id=".$this->iFilterId;
				break;
			case "LETTER":
				$sql_where .= " AND p.name LIKE '".$this->sFilterLetter."%'";
				break;
		}

		$from = $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage;

		$query = "  SELECT COUNT(p.id)
                    FROM ".TBL_PRODUCTS." AS p
                    $sql_from
                    WHERE 1=1
                    $sql_where
                ";

		$this->iRowCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg())
		{
			return false;
		}

		$query = "  SELECT
                        p.id,
                        p.name,
                        p.producers_id,                        
                        p.added_date,
                        p.released_date,
                        p.price,
                        p.availability,
                        p.stock_count,
                        p.active,
                        p.is_editors_pick,
                        p.has_img,
                        p.discount
                    FROM
                        ".TBL_PRODUCTS." AS p
                    	$sql_from
                    WHERE
                        1=1
                        $sql_where
                    ORDER BY
                        $this->sOrderBy
                    LIMIT
                        $from , $this->iRowsPerPage
                ";
		$this->aData = $this->roDB->GetArray($query);
		return !$this->roDB->GetLastErrorMsg();
	}



	public function Build()
	{
		//error loading list
		if (!$this->Load()){
			$params = array('err_message'=>$this->aLng['error_loading_list']);
			$this->sProductListHTMLcode = $this->roTemplate->parseRow("error.tpl",$params);
			return $this->sProductListHTMLcode;
		}

		// empty list
		if (!is_array($this->aData) || empty($this->aData)){
			$this->bIsListEmpty = true;
			return false;
		}


		$numbers = 1;
		$number = "";

		if($_SESSION['currency'] != DEFAULT_CURRENCY){
			$kurz = kurzNBS($_SESSION['currency']);
		}

		foreach($this->aData as $row){

			list($id,$name,$producers_id,$added_date,$released_date,$price,$availability,$stock_count,$active,$is_editors_pick,$has_img,$discount) = $row;

			$product_description = $this->aLng['product_'.$id];
			
			if($discount){
				$name = $name." (-".($discount/100)."%)";
				$price = $price * ((100-($discount/100))/100);
			}

			if($this->bIsAdmin){

				if($is_editors_pick==0){
					if($active==0){
						$add_to_editors = "- - -";
					} else {
						$params = array(
						'id'=>$id,
						'page'=>($this->iActualPage>1) ? "&page=".$this->iActualPage : "",
						);
						$add_to_editors = $this->roTemplate->parseRow("product_list_row_editors_link.tpl",$params);
					}
				} else {
					$add_to_editors = "&nbsp;";
				}

				$params = array(
				'id'=>$id,
				'product_name'=>$name,
				'active'=>$active,
				'producers_id'=>$producers_id,
				'add_to_editors'=>$add_to_editors,
				);

				if($this->sCriteria=="EDITORS"){
					$this->sProductListHTMLcode .= $this->roTemplate->parseRow("product_list_row_editors.tpl",$params);
				} else {
					$this->sProductListHTMLcode .= $this->roTemplate->parseRow("product_list_row.tpl",$params);
				}

			} else {

			if(($this->bIsPrivate)&&($stock_count>0)){
					$params = array('product_id'=>$id);
					$order = $this->roTemplate->parseRow("order_form.tpl",$params);
				} else {
					$order = "";
				}

				if($_SESSION['currency'] != DEFAULT_CURRENCY){
					$price = round($price / $kurz, 2);
				}

				$params = array(
				'id'=>$id,
				'name'=>$name,
				'date'=>date("d.m.Y",$released_date),
				'description'=>$product_description,
				'availability'=>($availability==0) ? $this->aLng['standard'] : $this->aLng['premium'],
				'stock'=>$stock_count>0 ? $stock_count : 0,
				'price'=>$price,
				'path'=>SERVER_URL."/product.php?id=".$id,
				'img_path'=>(is_file(IMG_PRODUCTS_DIR."/".$id."_thumb.jpg")) ? IMG_PRODUCTS_URL."/".$id."_thumb.jpg" : IMG_PRODUCTS_URL."/blank.gif",
				'order'=>$order,
				'logged'=>(($this->bIsPrivate)&&($stock_count>0))? "-1" : "",
				);

				$this->sProductListHTMLcode .= $this->roTemplate->parseRow("product_list_row.tpl",$params);
			}
		}

		return $this->sProductListHTMLcode;
	}


	public function Paging($source="product_list", $id=null, $order=null, $criteria=null)
	{
		$paging = "";
		$amp = ($id) ? "&id=".$id : "";
		$amp .= ($order) ? "&order=".$order : "";
		$amp .= ($criteria) ? "&criteria=".$criteria : "";
		$page_count = ceil($this->iRowCount / $this->iRowsPerPage);

		if($this->iActualPage>1){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1)
		{
			$_paging_count_pages_half = floor(PAGING_COUNT_PAGES / 2);

			$_page_start = max(1, min($this->iActualPage, $page_count - $_paging_count_pages_half) - $_paging_count_pages_half);
			$_page_stop = min(max($this->iActualPage, $_paging_count_pages_half) + $_paging_count_pages_half, $page_count);

			for($i=$_page_start; $i<=$_page_stop; $i++)
			{
				if($this->iActualPage==$i) {
					$params = array(
					'page_number'=>$i,
					);
					$paging .= $this->roTemplate->parseRow("paging_actual.tpl",$params);
				} else {
					$params = array(
					'source'=>$source,
					'page_number'=>$i,
					'page_name'=>$i,
					'amp'=>$amp
					);
					$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
				}
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if(!$this->bIsAdmin)
		{
			$params = array('numbers'=>$paging);
			$paging = $this->roTemplate->ParseRow("numbers.tpl", $params);
		}

		return $paging;
	}

	public function GetData(){
		return $this->aData;
	}

	public function GetRowCount(){
		return ($this->bIsListEmpty==true) ? 0 : $this->iRowCount;
	}

	public function GetResultFrom(){
		return ($this->bIsListEmpty==true) ? 0 : $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage + 1;
	}

	public function GetResultTo(){
		return ($this->bIsListEmpty==true) ? 0 :
		($this->iActualPage * $this->iRowsPerPage < $this->iRowCount) ?
		$this->iActualPage * $this->iRowsPerPage :
		$this->iRowCount ;
	}

}
?>
