<?php

class Register extends Top
{
	private $sErrorMsg;
	private $bSuccessful = false;

	private $sLogin;
	private $sPassword1;
	private $sPassword2;
	private $sEmail;
	private $sCountryIso = "sk";

	private $aCountryIsos;


	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $country_isos)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array);
		$this->aCountryIsos = $country_isos;
	}


	public function ProcessForm($post)
	{
		$this->sLogin = $post['login'];
		$this->sPassword1 = $post['password_1'];
		$this->sPassword2 = $post['password_2'];
		$this->sEmail = $post['email'];
		$this->sCountryIso = $post['country'];

		$form_errors = 0;


		if (empty($this->sLogin)){
			$this->sErrorMsg .= "<li>" . $this->aLng['empty_login'] . "</li>";
			$form_errors++;
		} elseif (isAlphaNum($this->sLogin) == false) {
			$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
			$form_errors++;
		} elseif ($this->LoginExists($this->sLogin) == true) {
			$this->sErrorMsg .= "<li>" . $this->aLng['login_exists'] . "</li>";
			$form_errors++;
		}


		if (empty($this->sPassword1)){
			$this->sErrorMsg .= "<li>" . $this->aLng['empty_password'] . "</li>";
			$form_errors++;
		} elseif (isAlphaNum($this->sPassword1) == false) {
			$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
			$form_errors++;
		} elseif ($this->sPassword1 != $this->sPassword2) {
			$this->sErrorMsg .= "<li>" . $this->aLng['password_missmatch'] . "</li>";
			$form_errors++;
		} elseif (false == isPassword($this->sPassword1)) {
			$this->sErrorMsg .= "<li>" . $this->aLng['password_invalid'] . "</li>";
			$form_errors++;
		}



		if (empty($this->sEmail)){
			$this->sErrorMsg .= "<li>" . $this->aLng['empty_email'] . "</li>";
			$form_errors++;
		} elseif (isEmail($this->sEmail) == false) {
			$this->sErrorMsg .= "<li>" . $this->aLng['invalid_email'] . "</li>";
			$form_errors++;
		}


		if ($form_errors > 0){
			$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
			$params = array("error_list"=>$this->sErrorMsg);
			$this->sErrorMsg = $this->roTemplate->ParseRow("errors.tpl", $params);
			return false;
		}

		if (!$this->SaveData()) {
			return false;
		} else {
			$this->bSuccessful = true;
			return true;
		}
	}


	private function LoginExists($login)
	{
		$query = "SELECT id,login FROM " . TBL_USERS . " WHERE LOWER(login) = '" . $this->roDB->MakeSecureString(strtolower($login)) . "'";
		$result = $this->roDB->GetRow($query);
		if (($this->roDB->GetLastErrorMsg()) || (!is_array($result))){
			return false;
		}else {
			return true;
		}
	}

	private function SaveData()
	{

    $random_string = randomString(10);

		$query = "INSERT INTO " . TBL_USERS . "(login,password,email,country_iso,registration_date,pass_string)
		VALUES(
		 '" . $this->roDB->MakeSecureString($this->sLogin) . "',
		 '" . md5($this->roDB->MakeSecureString($this->sPassword1) . $random_string) . "',
		 '" . $this->roDB->MakeSecureString($this->sEmail) . "',
		 '" . $this->roDB->MakeSecureString($this->sCountryIso) . "',
		 '" . time() . "',
		 '" . $random_string . "'
		 )";

		$this->roDB->Insert($query);
		if($this->roDB->GetLastErrorMsg()) {
			return false;
		}

		return true;
	}

	public function Show()
	{
		if($this->bSuccessful==true)
		{
			$this->roTemplate->AddContent("registration_ok.tpl");
		}
		else
		{
			$country_options = "";
			foreach($this->aCountryIsos as $country_iso)
			{
				$params = array(
				'id'=>$country_iso,
				'name'=>$this->aLng['country_'.$country_iso],
				'selected'=>""
				);
				if($country_iso == $this->sCountryIso)
				{
					$params['selected']="selected=\"selected\"";
				}
				$country_options .= $this->roTemplate->ParseRow("country_option.tpl", $params)."\n";
			}


			$params = array(
			"errors"=>$this->sErrorMsg,
			"login"=>$this->sLogin,
			"password_1"=>$this->sPassword1,
			"password_2"=>$this->sPassword2,
			"email"=>$this->sEmail ? $this->sEmail : "@",
			"countries"=>$country_options,
			);

			$this->roTemplate->AddContent("registration.tpl", $params);

		}

		return true;
	}
}

?>
