<?php
/*
    Template System v 1.0

    Required site structure (should be ok for 99,999999% of websites :-)):
    HEADER
    CONTENT
    FOOTER

    HEADER:
    This file SHOULD contain these lines:
    <title><?php echo $TPL['_page_title'];?></title>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php echo $TPL['_page_encoding'];?>" />

    Header is added in front of everything, and it's parameters are parsed at the end with Build() method.
    The reson for that is, that a script my at anytime overwrite chosen title or meta tags.

    CONTENT:
    Handled over AddContent() method, the parametrs are parsed on the fly when calling this method.
    It's content, put here anything u like...

    FOOTER:
    Always included after content. Optional parameters are parsed at the end with Build() method.
    Serves for closing open tags in header, like <body> or <html>.

    IMPORTANT
    These TPL indexes (variables) are reserved and are only passed to the header template:
    _page_title
    _page_encoding
    _lang  - this is parsed to ALL templates

    These indexes may only be changed over the object attributes and/or methods.
*/
class Template
{
    public  $sPageTitle     = "";
    public  $sCharset       = "";
    private $sThemesDir     = "";
    public  $sThemeName     = "";
    private $sContent       = "";
    private $sHeaderFile    = "";
    private $sHeaderParams  = "";
    private $sFooterFile    = "";
    private $sFooterParams  = "";
    private $sRelPath       = "";

    private $sLangVariable = "LNG"; // variable name, which holds an array of included languages
    private $sLangIso      = "";    // en, it, fr ...

    public function __construct($theme, $theme_dir, $rel_path)
    {
        $this->sThemeName = $theme;
        $this->sThemesDir = $theme_dir;
        $this->sRelPath   = $rel_path;
    }

    public function SetLangVar($lng, $iso=null)
    {
        $this->sLangVariable = $lng;
        $this->sLangIso = $iso;
    }

    public function SetHeader($tpl_file, $params=array())
    {
        $path = $this->sThemesDir."/".$this->sThemeName."/$tpl_file";
        if (!file_exists($path))
        {
            throw new Exception("File $path does not exist in ".__CLASS__."on line".__LINE__);
        }

        $this->sHeaderFile      = $path;
        $this->sHeaderParams    = $params;
    }

    public function SetFooter($tpl_file, $params=array())
    {
        $path = $this->sThemesDir."/".$this->sThemeName."/$tpl_file";
        if (!file_exists($path))
        {
            throw new Exception("File $path does not exist in ".__CLASS__."on line".__LINE__);
        }

        $this->sFooterFile      = $path;
        $this->sFooterParams    = $params;
    }

    public function SetPageTitle($title)
    {
        $this->sPageTitle = $title;
    }

    public function SetCharset($charset)
    {
        $this->sCharset = $charset;
    }

    public function AddContent($tpl_file, $params=array())
    {
        global $$this->sLangVariable;

        $path = $this->sThemesDir."/".$this->sThemeName."/$tpl_file";
        if (!file_exists($path))
        {
            throw new Exception("File $path does not exist in ".__CLASS__."on line".__LINE__);
        }

        $TPL =& $params;
        $TPL['_lang'] = $this->sLangIso;
        $TPL['rel_path'] = $this->sRelPath;
        ob_start();
        include($path);
        $this->sContent .= ob_get_contents();
        ob_clean();
    }

    public function AddRawContent($content)
    {
        $this->sContent .= $content;
    }

    public function Build()
    {
        global $$this->sLangVariable;

        $header="";
        $footer="";
        
        if ($this->sHeaderFile)
        {
            // first we build header
            $TPL =& $this->sHeaderParams;
            $TPL['_page_title'] = $this->sPageTitle;
            $TPL['_page_encoding'] = $this->sCharset;
            $TPL['_lang'] = $this->sLangIso;
            $TPL['rel_path'] = $this->sRelPath;
            ob_start();
            include($this->sHeaderFile);
            $header .= ob_get_contents();
            ob_clean();
        }

        if ($this->sFooterFile)
        {
            // build footer
            $TPL =& $this->sFooterParams;
            $TPL['rel_path'] = $this->sRelPath;
            ob_start();
            include($this->sFooterFile);
            $footer .= ob_get_contents();
            ob_clean();
        }
        // we put the page together
        $return = $header.$this->sContent.$footer;

        return $return;
    }

    public function ParseRow($tpl_file, $params=array())
    {
        global $$this->sLangVariable;
        $path = $this->sThemesDir."/".$this->sThemeName."/$tpl_file";
        if (!file_exists($path))
        {
            throw new Exception("File $path does not exist in ".__CLASS__."on line".__LINE__);
        }

        $TPL =& $params;
        $TPL['_lang'] = $this->sLangIso;
        $TPL['rel_path'] = $this->sRelPath;
        ob_start();
        include($path);
        $return .= ob_get_contents();
        ob_clean();
        return $return;
    }
}

?>