<?php
class User extends Top
{
	private $sErrorMsg;
	private $sMsg;
	private $bFormSaved = false;
		
	private $iId;
	private $sLogin;
	private $sPassword;
	private $sPassword1;
	private $sPassword2;
	private $sEmail;
	private $sCountryIso;
	private $aCountryIsos;
	private $iRegistrationDate;
	private $iAccountType;

	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $id=null, $is_admin=false, $country_isos)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array, $is_admin);
		$this->iId = is_numeric($id) ? $id : null;
		$this->aCountryIsos = $country_isos;
	}
	
	public function ShowChange(){

		if($this->bFormSaved){
			$this->sMsg=$this->aLng['user_saved'];
		}


		$country_options = "";
		foreach($this->aCountryIsos as $country_iso){
			$params = array(
			'id'=>$country_iso,
			'name'=>$this->aLng['country_'.$country_iso],
			'selected'=>($this->sCountryIso == $country_iso) ? "selected=\"selected\"" : "",
			);
			$country_options .= $this->roTemplate->ParseRow("country_option.tpl", $params)."\n";
		}


		if($this->bIsAdmin == true){

			if($this->iId){

				$query = "SELECT login FROM ".TBL_USERS." WHERE id=$this->iId";
				$user_name = $this->roDB->GetOne($query);
				if ($this->roDB->GetLastErrorMsg()){
					$this->sErrorMsg = $this->aLng['error_loading_user_db'];
					return false;
				}
				$user_name = "modify - ".$user_name;

				$login = "";

			} else {
				$user_name = "";
				$params = array('login'=>$this->sLogin);
				$login = $this->roTemplate->ParseRow("user_change_new.tpl", $params);
			}



			if ($this->sErrorMsg){
				$params = array("msg"=>$this->sErrorMsg);
				$status_error = $this->roTemplate->ParseRow("status_error.tpl", $params);
			} else {
				$status_error = "";
			}

			if ($this->sMsg){
				$params = array("msg"=>$this->sMsg);
				$status_ok = $this->roTemplate->ParseRow("status_ok.tpl", $params);
			} else {
				$status_ok = "";
			}


			$params = array(
			"status_error"=>$status_error,
			"status_ok"=>$status_ok,
			'login'=>$login,
			'email'=>$this->sEmail,
			'countries'=>$country_options,
			'user_name'=>$user_name,
			);

		} else {

			$params = array(
			'login'=>$this->sLogin,
			'email'=>$this->sEmail,
			'countries'=>$country_options,
			'message'=>$this->sMsg,
			'err_message'=>$this->sErrorMsg,
			);

		}

		$this->roTemplate->AddContent("user_change.tpl", $params);

		return true;
	}

	public function LoadData()
	{
		if($this->iId){
			if(!$this->LoadDB()){
				$this->sErrorMsg = $this->aLng['error_loading_user_db'];
				return false;
			}
		}

		return true;
	}

	public function DeleteData()
	{
		if (!$this->iId){
			return false;
		}
		if(!$this->DeleteDB()){
			$this->sErrorMsg = $this->aLng['error_deleting_user_db'];
			return false;
		}
		
		return true;
	}
	
	private function SaveData()
	{
		if ($this->iId){
			if(!$this->UpdateDB()){
				$this->sErrorMsg = $this->aLng['error_updating_user_db'];
				return false;
			}
		} else {
			if(!$this->InsertDB()){
				$this->sErrorMsg = $this->aLng['error_inserting_user_db'];
				return false;
			}
		}

		return true;
	}	

	private function DeleteDB()
	{
		$query = "DELETE FROM ".TBL_USERS." WHERE id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	public function Show()
	{
		$this->LoadDB();

		$time = time();
		
		$params = array(
		'login'=>$this->sLogin,
		'email'=>$this->sEmail,
		'activation_date'=>date("d.m.Y",$this->iSignupDate),
		'expiration_date'=>date("d.m.Y",$this->iExpirationDate),
		);

		$this->roTemplate->AddContent("user.tpl", $params);

		return true;
	}

	public function ProcessForm($post)
	{

		$form_errors = 0;

		$this->sLogin = (isset($post['login'])) ? $post['login'] : null;
		$this->sCountryIso = $post['country'];
		$this->sEmail = $post['email'];


		// check
		if($this->bIsAdmin == true){

			if(!$this->iId){

				if (empty($this->sLogin)){
					$this->sErrorMsg .= "<li>" . $this->aLng['empty_login'] . "</li>";
					$form_errors++;
				} elseif (isAlphaNum($this->sLogin) == false) {
					$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
					$form_errors++;
				} elseif ($this->LoginExists($this->sLogin) == true) {
					$this->sErrorMsg .= "<li>" . $this->aLng['login_exists'] . "</li>";
					$form_errors++;
				}

				$this->sPassword = $post['password_new_1'];
				$this->sPassword1 = $post['password_new_1'];
				$this->sPassword2 = $post['password_new_2'];


				if (empty($this->sPassword1)){
					$this->sErrorMsg .= "<li>" . $this->aLng['empty_password'] . "</li>";
					$form_errors++;
				} elseif (isAlphaNum($this->sPassword1) == false) {
					$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
					$form_errors++;
				} elseif ($this->sPassword1 != $this->sPassword2) {
					$this->sErrorMsg .= "<li>" . $this->aLng['password_missmatch'] . "</li>";
					$form_errors++;
				} elseif (false == isPassword($this->sPassword1)) {
					$this->sErrorMsg .= "<li>" . $this->aLng['password_invalid'] . "</li>";
					$form_errors++;
				}
				
				

			} else {

				if(($post['password_new_1']!="" || $post['password_new_2'])!=""){
					if($post['password_new_1'] == $post['password_new_2']){
						$this->sPassword = $post['password_new_1'];
					} else {
						$this->sErrorMsg .= "<li>" . $this->aLng['password_missmatch'] . "</li>";
						$form_errors++;
					}
				}

			}


		} else {
			if($post['password_old']!=""){
				if(
    				$post['password_new_1']!="" &&
    				$post['password_new_2']!="" &&
    				$post['password_new_1'] == $post['password_new_2'] &&
    				$this->Verify($post['password_old'])
				)
				{
					$this->sPassword = $post['password_new_1'];
				} else {
					$this->sErrorMsg .= "<li>" . $this->aLng['incorrect_password'] . "</li>";
					$form_errors++;
				}
			}

		}

		if(isEmail($this->sEmail) == false){
			$this->sErrorMsg .= "<li>" . $this->aLng['invalid_email'] . "</li>";
			$form_errors++;
		}

		if ($form_errors > 0){
			$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
			return false;
		}


		if(!$this->SaveData()){
			return false;
		} else {
			$this->bFormSaved = true;
			return true;
		}

	}


	private function LoginExists($login)
	{
		$query = "SELECT id,login FROM " . TBL_USERS . " WHERE LOWER(login) = '" . $this->roDB->MakeSecureString(strtolower($login)) . "'";
		$result = $this->roDB->GetRow($query);
		if ( ($this->roDB->GetLastErrorMsg()) || (!is_array($result)) ){
			return false;
		}else {
			return true;
		}
	}

	public function UpdateDB(){

		$email = $this->roDB->MakeSecureString($this->sEmail);
		$country_iso = $this->roDB->MakeSecureString($this->sCountryIso);

		if($this->sPassword){
			$password = $this->roDB->MakeSecureString($this->sPassword);
			$add = ",password='$password'";
		} else {
			$add = "";
		}

		$query = "UPDATE ".TBL_USERS." SET email='$email',country_iso='$country_iso'$add WHERE id=".$this->iId;
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function InsertDB()
	{

		$email = $this->roDB->MakeSecureString($this->sEmail);
		$login = $this->roDB->MakeSecureString($this->sLogin);
		$country_iso = $this->roDB->MakeSecureString($this->sCountryIso);
		$password = $this->roDB->MakeSecureString($this->sPassword);

		$query = "INSERT INTO ".TBL_USERS." (login,password,email,country_iso,registration_date) VALUES ('$login','$password','$email','$country_iso',".time().")";
		$this->roDB->Insert($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}

	}


	public function Verify($password){
		$query = "SELECT id,login FROM ".TBL_USERS." WHERE
                  LOWER(login) = '" . $this->roDB->MakeSecureString(strtolower($this->sLogin)) . "'
                  AND password = '" . $this->roDB->MakeSecureString($password) . "'";		
		$data = $this->roDB->GetRow($query);
		if (!is_array($data) || $this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	public function LoadDB()
	{
        $query = "SELECT    login,
                            password,
                            email,
                            country_iso,
                            account_type,
                            registration_date
                    FROM ".TBL_USERS." WHERE id=$this->iId";
		$row = $this->roDB->GetRow($query);
		if (!is_array($row) || $this->roDB->GetLastErrorMsg()){
			return false;
		}

		list(
    		$this->sLogin,
    		$this->sPassword,
    		$this->sEmail,
    		$this->sCountryIso,
    		$this->iAccountType,
    		$this->iRegistrationDate,
		) = $row;

		return true;
	}
}

?>
