<?php


class UserList extends Top
{
	private $aData = array();
	private $sUserListHTMLcode;
	private $iActualPage = 1;
	private $iRowsPerPage = 20;
	private $iRowCount;
	private $iTotalCount;
	private $sOrderBy = "registration_date DESC";
	private $sWhere = "";
	private $sName;
	private $bChecked;
	private $iDayFrom;
	private $iMonthFrom;
	private $iYearFrom;
	private $iDayTo;
	private $iMonthTo;
	private $iYearTo;
	private $sOrder;
	private $iSearchBy = 0;


	public function Show()
	{
		$this->Build();

		if($this->bIsAdmin==true){

			//parse time
			$time = time();
			$day_from = $this->iDayFrom ? $this->iDayFrom : date("d", $time);
			$month_from = $this->iMonthFrom ? $this->iMonthFrom : date("m", $time);
			$year_from = $this->iYearFrom ? $this->iYearFrom : date("Y", $time);

			$day_to = $this->iDayTo ? $this->iDayTo : date("d", $time);
			$month_to = $this->iMonthTo ? $this->iMonthTo : date("m", $time);
			$year_to = $this->iYearTo ? $this->iYearTo : date("Y", $time);

			$sDayFromHTMLcode = CreateOption($day_from,1,31);
			$sMonthFromHTMLcode = CreateOption($month_from,1,12);
			$sYearFromHTMLcode = CreateOption($year_from,2006,2006);

			$sDayToHTMLcode = CreateOption($day_to,1,31);
			$sMonthToHTMLcode = CreateOption($month_to,1,12);
			$sYearToHTMLcode = CreateOption($year_to,2006,2006);

			$params = array(
			'rows'=>$this->sUserListHTMLcode,
			'pages'=>$this->Paging(),
			'total_count'=>$this->iTotalCount,
			'day_from'=>$sDayFromHTMLcode,
			'month_from'=>$sMonthFromHTMLcode,
			'year_from'=>$sYearFromHTMLcode,
			'day_to'=>$sDayToHTMLcode,
			'month_to'=>$sMonthToHTMLcode,
			'year_to'=>$sYearToHTMLcode,
			'name'=>$this->sName,
			'checked'=>$this->bChecked?"checked":"",
			'search_by'=>$this->iSearchBy,
			);

		} else {

		}

		$this->roTemplate->AddContent("user_list.tpl", $params);

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetOrder($order_by)
	{
		$this->sOrder = $order_by;

		switch ($order_by){
			case "login":
				$this->sOrderBy = "login ASC";
				break;
			case "email":
				$this->sOrderBy = "email ASC";
				break;
		}
	}

	public function SetCriteria($const, $letter, $search_by){

		$this->sName = $letter;
		$this->iSearchBy = $search_by;

		switch ($const){
			case "LETTER":
				switch ($search_by){
					case 0: $this->sWhere = " AND ((login like '$letter%') OR (email like '$letter%'))";
					break;
					case 1: $this->sWhere = " AND login like '$letter%'";
					break;
					case 2: $this->sWhere = " AND email like '$letter%'";
					break;
				}
				break;
		}
	}

	public function SetDate($post){

		$this->bChecked = true;
		$this->iDayFrom = $post['day_from'];
		$this->iMonthFrom = $post['month_from'];
		$this->iYearFrom = $post['year_from'];
		$this->iDayTo = $post['day_to'];
		$this->iMonthTo = $post['month_to'];
		$this->iYearTo = $post['year_to'];

		$date_from = mktime(0,0,0,$post['month_from'],$post['day_from'],$post['year_from']);
		$date_to =   mktime(0,0,0,$post['month_to'],$post['day_to'],$post['year_to']);

		$this->sWhere .= " AND signup_date BETWEEN $date_from AND $date_to";

	}

	public function DeleteUser($id)
	{
		$user = new User($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng,$id);
		$user->DeleteData();
	}



	public function Load()
	{
		$from = $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage;

		$query = "SELECT count(id) FROM ".TBL_USERS;
		$this->iTotalCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}		
		
		$query = "SELECT count(id) FROM ".TBL_USERS." WHERE 1=1 $this->sWhere";
		$this->iRowCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "SELECT id,login,email,country_iso,account_type,registration_date,last_connect,last_ip FROM ".TBL_USERS." WHERE 1=1 $this->sWhere ORDER BY $this->sOrderBy LIMIT $from , $this->iRowsPerPage";
		$this->aData = $this->roDB->GetArray($query);
		if ($this->roDB->GetLastErrorMsg() || (!is_array($this->aData))){
			return false;
		} else {
			return true;
		}
	}



	private function Build()
	{
		if (!$this->Load()){
			$params = array('err_message'=>$this->aLng['error_loading_list']);
			$this->sUserListHTMLcode = $this->roTemplate->parseRow("error.tpl",$params);
			return false;
		}

		$time = time();
		$counter = 1;

		foreach($this->aData as $row){

			list($id,$login,$email,$country_iso,$account_type,$registration_date,$last_connect,$last_ip) = $row;

			if($this->bIsAdmin==true){

				$params = array(
				'id'=>$id,
				'login'=>$login,
				'country'=>$this->aLng['country_'.$country_iso],
				'email'=>$email,
				'register_date'=>date("d.m.Y",$registration_date),
				'modify'=>Menu::CheckPermissions(PERM_USERS_EDIT)?"<a href=\"user.php?id=$id&change\">Modify<a>":"Modify",
				'delete'=>Menu::CheckPermissions(PERM_USERS_EDIT)?"<a href=\"\"
				onClick=\"if(confirm('Really delete?'))
self.location='user_list.php?id=$id';
else self.location='user_list.php'\"
				>Delete<a>":"Delete",
				);

				$this->sUserListHTMLcode .= $this->roTemplate->parseRow("user_list_row.tpl",$params);

			} else {

			}
		}

		return true;
	}


	private function Paging($source="user_list")
	{
		$paging = "";
		$amp = ($this->sOrder) ? "&order=".$this->sOrder : "";
		$page_count = ceil($this->iRowCount / $this->iRowsPerPage);

		if($this->iActualPage>1){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1)
		{
			$_paging_count_pages_half = floor(PAGING_COUNT_PAGES / 2);

			$_page_start = max(1, min($this->iActualPage, $page_count - $_paging_count_pages_half) - $_paging_count_pages_half);
			$_page_stop = min(max($this->iActualPage, $_paging_count_pages_half) + $_paging_count_pages_half, $page_count);

			for($i=$_page_start; $i<=$_page_stop; $i++)
			{
				if($this->iActualPage==$i) {
					$params = array(
					'page_number'=>$i,
					);
					$paging .= $this->roTemplate->parseRow("paging_actual.tpl",$params);
				} else {
					$params = array(
					'source'=>$source,
					'page_number'=>$i,
					'page_name'=>$i,
					'amp'=>$amp
					);
					$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
				}  
				$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		return $paging;
	}	

	public function GetData(){
		return $this->aData;
	}

}
?>