<?php

require("DB_Base.class.php");

class DB_MySQL extends DB_Base
{
    private $hResult;

	public function Connect()
	{
		$connect_func = ($this->bIsPersistent)? "mysql_pconnect" : "mysql_connect";
		@$this->hLink = $connect_func($this->sDbHost, $this->sDbUser, $this->sDbPasswd);
		if (false == $this->hLink)
		{
            $this->bIsConnected = false;
            $this->HandleError("Error code " . mysql_errno() . ": " . mysql_error());
            return false;
		}
	    $this->bIsConnected = true;
		return true;
    }

	public function SelectScheme($db_scheme)
	{
		if (false == $this->IsConnected())
		{
			$this->HandleError("Error code -1: Not connected to MySQL");
			return false;
		}

		if (false == mysql_select_db($db_scheme, $this->hLink))
		{
        	$this->HandleError("Error code ".mysql_errno($this->hLink).": ".mysql_error($this->hLink));
        	return false;
		}
        return true;
	}

	public function Close()
	{
		if (false == $this->hLink)
		{
		    $this->HandleError("Error code -2: DB_MySQL::Close(): Not connected.");
			return false;
		}

		if(false == mysql_close($this->hLink))
		{
    		$this->HandleError("Error code " . mysql_errno($this->hLink) . ": " . mysql_error($this->hLink));
    		return FAIL;
		}
		$this->mIsConnected = false;
		return true;
	}

	public static function MakeSecureString($string)
	{
        $string = parent::MakeSecureString($string);
        $string = mysql_real_escape_string($string);
        return $string;
	}

    protected function MakeQuery($query)
    {
        parent::MakeQuery($query);
        $this->ClearError();
        $this->sQuery = $query;
        $this->iNumRows = null;
        $this->iNumColumns = null;
        $this->iAffectedRows = null;

        if (false == $this->bIsConnected)
		{
			$this->HandleError("Error code -1:DB_MySQL::MakeQuery(): Not connected to MySQL");
			return false;
		}

        $query_function = "mysql_query";

		$this->hResult = $query_function($this->sQuery, $this->hLink);

		if (0 != mysql_errno($this->hLink))
		{
    		$this->HandleError("Error code " . mysql_errno($this->hLink) . ": " . mysql_error($this->hLink));
    		return false;
		}
        return true;
    }

	public function GetNumRows()
	{
        if (null !== $this->iNumRows)
        {
            return $this->iNumRows;
        }

        $this->iNumRows = @mysql_num_rows($this->hResult);
        return $this->iNumRows;
	}

    function GetInsertId()
    {
        return @mysql_insert_id($this->hLink);
    }

    public function GetNumAffected()
    {
	    if (null != $this->iAffectedRows)
	    {
            return $this->iAffectedRows;
	    }
        $this->iAffectedRows = @mysql_affected_rows($this->hLink);
        return $this->iAffectedRows;
    }

    protected function GetArrayLive($query)
    {
        if (false === $this->MakeQuery($query))
        {
            return false;
        }

		$fetch_func = "mysql_fetch_row";
		$ret = array();
        while ($row = $fetch_func($this->hResult))
        {
            $ret[] = $row;
        }
        $this->iNumRows = count($ret);
        mysql_free_result($this->hResult);
        return $ret;
    }

    protected function GetRowLive($query)
    {
        if (false === $this->MakeQuery($query))
        {
            return false;
        }

		$fetch_func = "mysql_fetch_row";
        $row = $fetch_func($this->hResult);
        $this->iNumRows = count($row);
        mysql_free_result($this->hResult);
        return $row;
    }

	protected function GetColumnLive($query)
	{
		if (false === $temp_res = $this->GetArrayLive($query))
		{
    		return false;
		}

	    $ret = array();
		if (is_array($temp_res))
	    {
            foreach ($temp_res as $row)
            {
                $ret[] = $row[0];
            }
	    }
		return $ret;
	}

	protected function GetOneLive($query)
	{
        if (false === $this->MakeQuery($query))
        {
            return false;
        }
		$res = mysql_fetch_row($this->hResult);
		$ret = $res[0];
		$this->iNumRows = count($ret);
		mysql_free_result($this->hResult);
		return $ret;
	}

	public function Insert($query)
	{
		return $this->MakeQuery($query);
	}

	public function Delete($query)
	{
        return $this->MakeQuery($query);
	}

	public function Update($query)
	{
        return $this->MakeQuery($query);
	}

    public function Execute($query)
    {
        return $this->MakeQuery($query);
    }

}
?>
