<?php

function isAlphaNum($string)
{
	return preg_match("/^[a-zA-Z0-9_]+$/", $string);
}

function isEmail($address = "", $chck_dns = false)
{
	if (empty($address))
	{
		return false;
	}

	if (1 != preg_match("/^[\w]{1}[\w\.\-_]*@[\w]{1}[\w\-_\.]*\.[\w]{2,6}$/i", $address))
	{
		return false;
	}

	if ($chck_dns)
	{
		list($user, $host) = split("@", $address);

		if (!$this->is_host($host))
		{
			return false;
		}
	}
	return true;
}

function isPassword($password)
{
	if (6 > strlen($password))
	{
		return false;
	}
	return true;
}

function rm($fileglob)
{
	if (is_string($fileglob)) {
		if (is_file($fileglob)) {
			return unlink($fileglob);
		} else if (is_dir($fileglob)) {
			$ok = rm("$fileglob/*");
			if (! $ok) {
				return false;
			}
			return rmdir($fileglob);
		} else {
			$matching = glob($fileglob);
			if ($matching === false) {
				trigger_error(sprintf('No files match supplied glob %s', $fileglob), E_USER_WARNING);
				return false;
			}
			$rcs = array_map('rm', $matching);
			if (in_array(false, $rcs)) {
				return false;
			}
		}
	} else if (is_array($fileglob)) {
		$rcs = array_map('rm', $fileglob);
		if (in_array(false, $rcs)) {
			return false;
		}
	} else {
		trigger_error('Param #1 must be filename or glob pattern, or array of filenames or glob patterns', E_USER_ERROR);
		return false;
	}

	return true;
}

function CreateOption($selected,$from,$to)
{
	$result = "";

	for($i=$from; $i<$to+1; $i++){
		if ($i<10)
		$result .= "<option value=\"0$i\"";
		else
		$result .= "<option value=\"$i\"";

		if($i==$selected)
		$result .= "selected";
		$result .= ">$i</option>";
	}

	return $result;
}

function makeDir($dir, $mode = 0777)
{
	if (is_dir($dir) || @mkdir($dir,$mode)) return TRUE;
	return false;
}

function randomString($length=5, $str=''){
	for($i=0; $i<$length; $i++){

		$ord = rand(48,122);

		if( ( ($ord>=48) && ($ord<=57) ) || ( ($ord>=97) && ($ord<=122) ) ){
			$str .= chr($ord);
		} else {
			$str .= randomString(1);
		}
	}
	return $str;
}


function kurzyNBS($kur="aud,czk,dkk,eur,jpy,cad,huf,nok,pln,sit,chf,sek,usd,gbp,xdr",$stl="kpp,krajina,mena,mnozstvo,iso,kurz,datum,cislo",$hlavicka="true",$tab=0)
{
	$stlpceNazvy = array("kpp"      =>  "KPP",
	"krajina"  =>  "Krajina",
	"mena"     =>  "Mena (nzov)",
	"mnozstvo" =>  "Mnostvo",
	"iso"      =>  "Mena",
	"kurz"     =>  "Kurz stred",
	"datum"    =>  "Dtum zaiatku platnosti",
	"cislo"    =>  "Poradov slo lstka v roku");


	$subor = SERVER_DIR."/AKTKLSL.SDF";
	$suborObsah = file($subor);

	$odsadenie = str_pad("",$tab,"\t");

	$stlpce = explode(",",$stl);
	$kurzy = explode(",",$kur);

	$tabulkaZac = $odsadenie."<table class=\"kurzy\">\n";

	if ($hlavicka=="true")
	{
		$tabulkaZac.= $odsadenie."\t<tr>\n";
		for($a=0;$a<count($stlpce);$a++)
		$tabulkaHlavicka.= "<th class=\"".$stlpce[$a]."\">".$stlpceNazvy[$stlpce[$a]]."</th>";

		$tabulkaZac.= $odsadenie."\t\t".$tabulkaHlavicka."\n";
		$tabulkaZac.= $odsadenie."\t</tr>\n";
	}

	$tabulkaRiadky = "";
	
	for($i=0;$i<count($suborObsah);$i++)
	{
		$riadok = $suborObsah[$i];

		$kpp        =   substr($riadok,0,2);
		$krajina    =   rtrim(substr($riadok,3,15));
		$mena       =   rtrim(substr($riadok,19,10));
		$mnozstvo   =   ltrim(substr($riadok,30,4));
		$iso        =   substr($riadok,35,3);
		$kurz       =   ltrim(substr($riadok,40,7));

		$datum      =   substr($riadok,48,8);
		$datumRok = substr($datum,0,4);
		$datumMes = substr($datum,4,2);
		$datumDen = substr($datum,6,2);
		$datum      =   $datumDen.".".$datumMes.".".$datumRok;
		$cislo      =   ltrim(substr($riadok,57,3));

		if ($mena!="" && in_array(strtolower($iso),$kurzy))
		{
			$tabulkaBunky = "";
			$tabulkaRiadky.= $odsadenie."\t<tr class=\"".strtolower($iso)."\">\n";
			for ($a=0;$a<count($stlpce);$a++)
			{
				$tabulkaBunky.= "<td width=\"100\" class=\"".$stlpce[$a]."\">".$$stlpce[$a]."</td>";
			}
			$tabulkaRiadky.= $odsadenie."\t\t".$tabulkaBunky."\n";
			$tabulkaRiadky.= $odsadenie."\t</tr>\n";
		}
	}

	$tabulkaKoniec = $odsadenie."</table>\n";

	$tabulka = $tabulkaZac.$tabulkaRiadky.$tabulkaKoniec;

	return $tabulka;
}

function kurzNBS($kur="EUR")
{
	$subor = SERVER_DIR."/AKTKLSL.SDF";
	$suborObsah = file($subor);

	for($i=0;$i<count($suborObsah);$i++)
	{
		$riadok = $suborObsah[$i];

		$kpp        =   substr($riadok,0,2);
		$krajina    =   rtrim(substr($riadok,3,15));
		$mena       =   rtrim(substr($riadok,19,10));
		$mnozstvo   =   ltrim(substr($riadok,30,4));
		$iso        =   substr($riadok,35,3);
		$kurz       =   ltrim(substr($riadok,40,7));

		$datum      =   substr($riadok,48,8);
		$datumRok = substr($datum,0,4);
		$datumMes = substr($datum,4,2);
		$datumDen = substr($datum,6,2);
		$datum      =   $datumDen.".".$datumMes.".".$datumRok;
		$cislo      =   ltrim(substr($riadok,57,3));

		if ($iso==$kur)
		{
			return $kurz;
		}

	}

	return 1;
}

function check_pirates($usrAgent)
{
	$uAgant = strtolower($usrAgent);

	$sePirates = array("webcopier", "teleport");

	while (list($key, $value) = each($sePirates)) {
		if (strstr($uAgant,$value))
		return true;
	}
	return false;
}

function check_robots($usrAgent)
{
	$uAgant = strtolower($usrAgent);

	$seRobots = array(
	'almaden.ibm.com',
	'jeeves',
	'crawler@fast',
	'fast-webcrawler',
	'googlebot',
	'scooter',
	'slurp',
	'szukacz',
	'msnbot',
	't-h-u-n-d-e-r-s-t-o-n-e',
	'teoma',
	'zyborg' ,
	'inktomi',
	'appie',
	'crawler',
	'frooglebot',
	'geobot',
	'infoseek',
	'lycos_',
	'ncsa beta',
	'w3c_validator',
	'architext',
	'bjaaland',
	'gulliver',
	'harvest',
	'htdig',
	'linkwalker',
	'moget',
	'muscatferret',
	'myweb',
	'yahoo'
	);

	while (list($key, $value) = each($seRobots)) {
		if (strstr($uAgant,$value))
		{
			return true;
		}
	}
	return false;
}
	$query  = "SELECT * FROM player WHERE strtolower(surname) LIKE  '%".strtolower($text)."%';";
?>
