<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title></title>
    <script src="js/support/jquery-1.11.0.js" charset="utf-8"></script>
    <script src="js/support/d3.min.js" charset="utf-8"></script>
    <script src="js/support/jquery-linedtextarea.js" charset="utf-8"></script>
    <script src="js/drawPaths.js" charset="utf-8"></script>
    <script src="js/lines.js" charset="utf-8"></script>
    <script src="js/nodes.js" charset="utf-8"></script>
    <script src="js/canvas.js" charset="utf-8"></script>
    <script src="js/treeLayout.js" charset="utf-8"></script>
    <script src="js/parser.js" charset="utf-8"></script>
    <script src="js/drawTree.js" charset="utf-8"></script>
    <script src="js/cycles.js" charset="utf-8"></script>
    <script src="js/lineOfCode.js" charset="utf-8"></script>
    <script src="js/config.js" charset="utf-8"></script>
    <script src="js/support/modernizr.custom.74881.js" charset="utf-8"></script>
    <script src="js/UI.js" charset="utf-8"></script>
    <link href="css/jquery-linedtextarea.css" type="text/css" rel="stylesheet"/>
    <link href="css/layout.css" type="text/css" rel="stylesheet"/>
    <link href="css/tree.css" type="text/css" rel="stylesheet"/>
    <link href="css/bootstrap.min.css" type="text/css" rel="stylesheet"/>
</head>
<body>

    <div>
        <div id="leftColumn" class="mainColumns">

            <div id="descriptionStep0" class="panel panel-primary examples-panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Zadávanie vstupu:</h3>
                </div>
                <div class="panel-body">
                    <p>Ako vstupný programovací jazyk do aplikácie sa používa programovací jazyk z cvičení.</p>
                    <p>Môžete si vybrať už napísaný program z pravého stĺpca alebo si môžete napísať vlastný.</p>

                    <p>Možné príkazy:</p>
                    <ul>
                        <li>začiatok programu - begin( vstupné priradenie )</li>
                        <li>koniec programu - end( výstupné priradenie )</li>
                        <li>priradenie - premenná := číslo/premenná</li>
                        <li>podmienka -> skok - if( podmienka ) then skok</li>
                        <li>podmienka -> priradenie - if( podmienka ) then priradenie</li>
                        <li>príkaz skoku - goto číslo_riadka</li>
                    </ul>

                    <p>Príklad:</p>
                    <p>
                        begin [y1, y2] := [x, a] <br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[y1] := [g(y1, y2)]<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if p1(y1) then goto 5<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[y1, y2] := [f1(y1), f2(y2)]<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;goto 1<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[y2] := [g(y2, y1)]<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if p2(y2) then goto end<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[y1, y2] := [g1(y1), g2(y2)]<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;goto 1<br>
                        end [z] := [g1(y1)]<br>
                    </p>
                </div>
            </div>
            <div  class="panel panel-primary">
                <div class="panel-heading" id="descriptionStep1">
                    <h3 class="panel-title">Výber deliacich bodov:</h3>
                </div>
                <div class="panel-body">
                    <p>V každom programe sa vyskytujú minimálne dva deliace body a to začiatok a koniec programu, označme ich A,B. Ak postupnosť príkazov medzi bodmi A a B obsahuje cyklus, potrebujeme ju rozdeliť ďalším bodom. Ideálne miesto na umiestnenie vnútorného deliaceho bodu je na mieste kde sa z cyklu vychádza.</p>

                    <p>Po rozdelení cyklu deliacim bodom, označme si ho C, skontrolujeme vzniknuté cesty medzi bodmi A a C a bodmi C a B na prítomnosť ďalších cyklov. Takýmto spôsobom postupujeme až pokým nám vzniknú konečné cesty, pre ktoré platí, že ani jedna z nich neobsahuje cyklus.</p>

                    <p>Na konci tohoto kroku musí platiť, že deliace body nám rozdelili program na konečný počet konečných ciest.</p>

                    <p>Deliaci bod pridáme tak, že klikneme na vrchol <b>pred</b> ktorým chceme deliaci bod umiestniť. Ak na vrchol klikneme znova, deliaci bod odoberieme.</p>
                    <p><b>Veľkosť vrchola sa prispôsobuje veľkosti písma, ak graf nie je dobre zobrazený, použite zoom prehliadača (ctrl + -), skopírujte kód napravo, reloadnite stránku.</b></p>
                </div>
            </div>
            <div  class="panel panel-primary">
                <div class="panel-heading" id="descriptionStep2">
                    <h3 class="panel-title">Tvorenie invariantov:</h3>
                </div>
                <div class="panel-body">
                    <p>Pre každý novopridaný deliaci bod sa nám objavilo textové políčko, do ktorého je potrebné napísať invariant pre daný deliaci bod.</p>

                    <p>Invariant <i>I_A</i> je podmienka viazaná k bodu programu <i>A</i>, vyjadrená ako formula špecifického jazyka, ktorá platí pri každom prechode bodom <i>A</i>.</p>

                    <p>Pre začiatočný a koncový bod nám ako invariant slúži vstupná a výstupná podmienka, preto nám stačí sformulovať invarianty pre ostatné (ak sú nejaké) deliace body.</p>

                    <p>Zkonštruovanie invariantu je nerozhodnuteľný problém, ale je známich niekoľko heuristík, ktoré môžu dopomôcť k jeho vytvoreniu. Niektoré z nich môžete nájsť v zbierke z cvičení.</p>

                    <p>Ak invariant zostrojiť neviete, skúste ho vypísať v tvare <i>I_i(vars)</i>, kde <i>i</i> je číslo vrchola pred ktorým deliaci bod stojí a <i>vars</i> sú premenné, ktoré sa pred týmto deliacim bodom objavili v programe.</p>
                </div>
            </div>
            <div  class="panel panel-primary">
                <div class="panel-heading" id="descriptionStep3">
                    <h3 class="panel-title">Generovanie verifikacnych podmienok:</h3>
                </div>
                <div class="panel-body">
                    <p>Odporúčame si odvodiť R a r samostatne, potom ich môžete skontrolovať tak, že budete klikať na tlačidlo <i>Generuj</i> a overíte si svoje riešenie.</p>
                    <input id="gen-btn" class="btn btn-info" value="Generuj" type="button" />

                    <p>Verifikačné podmienky konštruujeme pomocou spätnej substitúcie.</p>
                    <p><b>Označenia</b></p>
                    <p><i>Rα (x, y)</i> popisuje podmienku, ktorá musí platiť po prejdení cesty <i>α</i>.</p>
                    <p><i>rα (x, y)</i> popisuje stav vektorov <i>x, y</i> po prechode cestou <i>α</i>.</p>

                    <p>Budeme ním ukazovať zmenu vektora y po prejdení cesty <i>α</i>, vektor <i>x</i> sa nám nezmení,
                        pretože obsahuje iba vstupné premenné.
                    </p>
                    <p>Verifikačnú podmienku pre cestu <i>α</i> skonštruujeme pomocou nasledujúcich princípov,
                        ktoré nám ukazujú ako spätnú zmenu stavu <i>Rα (x, y)</i> a <i>rα (x, y)</i>.
                    </p>
                    <p>Ak za vykonaním príkazu je podmienka a stav premenných v tvare <i>Rα (x, y)</i> a
                        <i>rα (x, y)</i>, potom pred vykonaním príkazu boli v tvare:
                    </p>
                    <p>Príkaz skoku: <i>Rα (x, y), rα (x, y)</i> (bez zmeny)
                    </p>
                    <p>Príkaz priradenia <i>p</i> tvaru <i>y = p(x, y): Rα (x, p(x, y)), rα (x, p(x, y))</i>
                    </p>
                    <p>True vetva podmienky <i>i</i> tvaru <i>if (i(x, y)): Rα (x, y) ∧ i(x, y), rα (x, y)</i>
                    </p>
                    <p>Verifikačná podmienka pre cestu α medzi deliacimi bodmi <i>A</i> a <i>B</i> je potom <i>IA & rα (x, y) ⇒
                        IB (x, y)</i>.
                    </p>
                </div>
            </div>
            <div  class="panel panel-primary">
                <div class="panel-heading" id="descriptionStep4">
                    <h3 class="panel-title">Dokazovanie verifikacnych podmienok:</h3>
                </div>
                <div class="panel-body">
                    <p>Posledný krok Floydovej metódy je overiť všetky skonštruované verifikačné podmienky, v našom prípade formuly predikátovej logiky.</p>

                    <p>Ak platia všetky verifikačné podmienky skonštruované korektne na programe P krokmi 1-4, potom program P je čiastočne správny.</p>
                </div>
            </div>
        </div>
    </div>
    <div id="visualizationSpace" class="mainColumns">
        <div id="invariants"></div>
        <div id="editor_space">
            <div class="input-group">
                <span class="input-group-addon">Vstupná podmienka</span>
                <input type="text" class="form-control input-cond" placeholder="Napis invariant">
            </div>
            <div class="input-group">
                <span class="input-group-addon">Výstupná podmienka</span>
                <input type="text" class="form-control output-cond" placeholder="Napis invariant">
            </div>
            <div class="input-group">
                <textarea class="lined" id="editorTextArea" cols="70" rows="30"></textarea>
            </div>
        </div>
    </div>
    <div id="rightColumn" class="mainColumns">
        <div>
            <input type="button" id="nextButton" class="btn btn-info" value="Ďalší krok!">
        </div>

        <div  class="panel panel-primary">
            <div class="panel-heading">
                <h3 class="panel-title">Kód skúmaného programu:</h3>
            </div>
            <div class="panel-body" id="steps">
                <div>1.) Zadanie kódu programu.</div>
                <div>2.) Výber deliacich bodov.</div>
                <div>3.) Zadanie invariantov.</div>
                <div>4.) Vygenerovanie verifikačných podmienok.</div>
                <div>5.) Dokázanie verifikačných podmienok.</div>
            </div>
        </div>
        <div class="panel panel-primary examples-panel">
            <div class="panel-heading">
                <h3 class="panel-title">Príklady:</h3>
            </div>
            <div class="panel-body">
                <input type="button" class="btn btn-example" data-exid="ex0" 
                value="ex1" />
                <input type="button" class="btn btn-example" data-exid="ex1" 
                value="reverz" />
                <input type="button" class="btn btn-example" data-exid="ex2" 
                value="dolna cast sqrt(x)" /> 
            </div>
        </div>
        <div  class="panel panel-primary code-wraper">
            <div class="panel-heading">
                <h3 class="panel-title">Kód skúmaného programu:</h3>
            </div>
            <div class="panel-body" id="code">
            </div>
        </div>
    </div>

</div> 
<?php include 'examples.php'; ?>
</body> 
<script>
    UI.prototype.initLayout(document);     
    UI.prototype.changeTextByStep();


/*
* Listeners
*/

$("#rightColumn").on("click","#nextButton",function(){
    UI.iStep++;
    if(UI.iStep == 5){
        location.reload();
    } else {
        stepChange(UI.iStep);
    }
});

$("#visualizationSpace").on("click",".node",function(){
    if(UI.iStep == 1){
     var shape = $(this).children().eq(0);
     if(!shape.attr('data-selected') || shape.attr('data-selected') == 0){
        d3.select("svg").append("svg:circle")
        .attr("cx", shape[0]["__data__"].x + 25)
        .attr("cy", shape[0]["__data__"].y + 10)
        .attr("r", "6")
        .attr("class", "breakPoint" + shape.attr('data-id'))
        .attr("stroke", "black");
        shape.attr('data-selected', '1');
    } else {
     d3.select(".breakPoint" + shape.attr('data-id')).remove();
     shape.attr('data-selected', '0');
 }
}
});

$('.btn-example').click(function(){
    var example = $(this).attr('data-exid');
    var exampleText = $('.'+example).text();
    var exampleVp1 = $('.'+example+'vp1').text();
    var exampleVp2 = $('.'+example+'vp2').text();
    $('#editorTextArea').text(exampleText);
    $('.input-cond').val(exampleVp1);
    $('.output-cond').val(exampleVp2);
});

$('#gen-btn').click(function(){
    PathsClass.prototype.next();
});

$("#visualizationSpace").on("click",".checkbox",function(){
    var unchecked = false;
    $.each($(".checkbox"), function(){
        if(!$(this).get(0).checked) unchecked = true;
    });
    if(!unchecked){
        window.alert("Gratulujeme, dokázali ste čiastočnú správnosť daného programu!")
    }
});

</script>
</html>


