function UI(){}

UI.iStep = 0;
UI.ways = [];
UI.nodes = [];
UI.verificationConditions = [];

UI.prototype.changeTextByStep = function(){
	$("#leftColumn").children().hide();
	$("#leftColumn").children().eq(UI.iStep).show();
	if(UI.iStep === 0){
		$("#code").hide();
		$('.examples-panel').show();
		$('.code-wraper').hide();
	} else {
		$("#code").show();
		$('.examples-panel').hide();
		$('.code-wraper').show();
	}
	if(UI.iStep === 2){
		$("#invariants").show();
	} else {
		$("#invariants").hide();
	}

	$(".actualStep").removeClass("actualStep");
	$("#steps").children().eq(UI.iStep).addClass("actualStep");
}

function drawTree(input){
	var canvasClass = new CanvasClass(config);
	var canvas = canvasClass.createCanvas();

	var drawTreeClass = new DrawTreeClass(config);
	if(drawTreeClass.Draw(input, canvas) === -1){
		return -1;
	}
}

function  addTextBoxesForEveryBreakPoint(){
	d3.selectAll(".node").each(function(index){
		if($(this).children().eq(0)[0].getAttribute("data-selected") === "1"){
			$("#invariants").append('<div class="input-group">\
				<span class="input-group-addon">Invariant k deliacemu bodu pred vrcholom ' +
				$(this).children().eq(0)[0].getAttribute("data-id") + '</span>\
				<input type="text" class="form-control invariant" data-id="' + 
				$(this).children().eq(0)[0].getAttribute("data-id") + 
				'" placeholder="Tu prosím napíš invariant"></div>');
		}
	});
}

function stepChange(){
	switch (UI.iStep){
		case 0:
            //nahradit vytvaranim editora a ukladat napisany kod
            location.reload();
            break;
            case 1:
            var input = $('textarea#editorTextArea').val();
            $(".container").empty();
			//pokus o vykreslenie stromu
			var res = drawTree(input);
			if( res === -1){
				UI.iStep--;
				return;
			} else {
				$("#editor_space").css("display", "none");
				$("#code").html(input);
			}
			break;
			case 2:
            //kontrola cyklov
            var input = $('#code').html();
            var drawTreeClass = new DrawTreeClass(config);
            var result = drawTreeClass.CheckCycles(input);
            var cycles = result[0];
            UI.ways = result[1];
            nodes = result[2];
            
            if(cycles.length != 0){
			//vypisanie cyklu
			UI.iStep--;
			var cycleText = "";
			for (var i = cycles[0].length - 1; i >= 0; i--) {
				if(cycles.length == 0){
					cycleText = cycles[0][i];
				} else {
					cycleText += " -> " + cycles[0][i];
				}
			};
			window.alert(" Nerozbil si minimalne tento cyklus: " + cycleText);
			return false;
		} else {
			UI.prototype.changeTextByStep();
			addTextBoxesForEveryBreakPoint();
		}
		break;
		case 3:
		var invariants = getInvariants();
		var input = $('#code').html();
		var linesOfCode = ParserClass.prototype.getLinesOfCode(nodes, input);
		UI.verificationConditions = PathsClass.prototype.Draw(UI.ways, nodes, invariants, linesOfCode);
		break;

		case 4:
		var canvas = $('#visualizationSpace');
		canvas.empty();
		canvas.append('<div class="panel panel-default">' +
			'<table class="table">' +
			'<tr><th>Verifikačná podmienka</th><th>Dokázané?</th></tr>' + 
			'</table>'+
			'</div>');
		for (var i = 0; i < UI.verificationConditions.length; i++) {
			$('.table').append('<tr><td>' + UI.verificationConditions[i] +
				'</td><td><input class="checkbox" type="checkbox" value="'+i+'"/></td></tr>');
		};
		$("#nextButton").attr("value", "Skúsiť dokázať ďalší program!");
		break;
	}
	// na konci, ak chyba aby to nezbehlo
	UI.prototype.changeTextByStep(); 
}

function getInvariants(){
	var invariants = [];
	invariants.push([$('.input-cond').val(),'0']);
	invariants.push([$('.output-cond').val(),'E']);
	$.each($('.invariant'), function(){
		invariants.push([$(this).val(),parseInt($(this).attr('data-id'))]);
	});
	return invariants;
}

/*
 * initLayoutFunctions
 */

 UI.prototype.initLayout = function(document){
 	$("body").css("margin", config.body.margin);
        var windowWidth = $(window).width() - getScrollBarWidth(document) - config.body.margin*2 -4;//border odpocitany
        config.middleColumn.width = windowWidth/2;
        config.middleColumn.height = $(window).height() - config.body.margin*2;
        config.sideColumns.width = windowWidth/4;
        config.sideColumns.height = $(window).height() - config.body.margin*2;
        $("#leftColumn").css('width', config.sideColumns.width);
        $("#leftColumn").css('height', config.sideColumns.height);
        $("#rightColumn").css('width', config.sideColumns.width);
        $("#rightColumn").css('height', config.sideColumns.height);
        $("#visualizationSpace").css('width', config.middleColumn.width);
        $("#visualizationSpace").css('height', config.middleColumn.height);
    $(function () {
    	$(".lined").linedtextarea(
    		);
    });
}

//prevzata funkcia, ktora zisti sirku scrollbaru
function getScrollBarWidth (document) {
	var inner = document.createElement('p');
	inner.style.width = "100%";
	inner.style.height = "200px";

	var outer = document.createElement('div');
	outer.style.position = "absolute";
	outer.style.top = "0px";
	outer.style.left = "0px";
	outer.style.visibility = "hidden";
	outer.style.width = "200px";
	outer.style.height = "150px";
	outer.style.overflow = "hidden";
	outer.appendChild (inner);

	document.body.appendChild (outer);
	var w1 = inner.offsetWidth;
	outer.style.overflow = 'scroll';
	var w2 = inner.offsetWidth;
	if (w1 == w2) w2 = outer.clientWidth;

	document.body.removeChild (outer);

	return (w1 - w2);
};