function PathsClass() {};

PathsClass.prototype.iteratorI = 0;
PathsClass.prototype.iteratorJ = 0;
PathsClass.prototype.paths = 0;
PathsClass.prototype.nodes = 0;
PathsClass.prototype.ways = 0;

PathsClass.prototype.Draw = function (ways, nodes, invariants, linesOfCode) {
    // nahradenie oznacenia posledneho invariantu z 'E' na id posledneho prikazu
    invariants[1][1] = nodes.length -1;
    var paths = [];
    //upravenie cisla vrcholu invariantu - vystupna podmienka
    $.each(ways, function(){
        paths.push(computeWay($(this), nodes, invariants, linesOfCode));
    });
    drawPaths(paths,nodes,ways);
    return getVerificationConditions(ways,invariants,paths);
};

/*
 *    -------- DRAWING PATHS FUNCTIONS--------------------
 */
 function drawPaths(paths,nodes, ways){
    //nacitanie do statickych premennych
    PathsClass.prototype.paths = paths;
    PathsClass.prototype.nodes = nodes;
    PathsClass.prototype.ways = ways;
    var canvas = $('#visualizationSvg');
    canvas.empty();
    var pathsCount = paths.length;
    var sideGap = 100;
    var downGap = 50;
    var upperTextGap = 20;
    var downTextGap = 20;
    var circleR = 6;

    var lineHeightGap = (canvas.attr('height') / pathsCount) ;
    
    for (var i = 1; i <= pathsCount; i++) {
        //nakreslenie ciary pre jednu cestu
        var line = document.createElementNS('http://www.w3.org/2000/svg', 'line');
        line.setAttribute('x1', sideGap);
        line.setAttribute('y1', lineHeightGap*i - downGap - lineHeightGap/pathsCount);
        line.setAttribute('x2', canvas.attr('width') - sideGap);
        line.setAttribute('y2', lineHeightGap*i- downGap - lineHeightGap/pathsCount);
        line.setAttribute('stroke', 'rgb(0,0,0)');
        line.setAttribute('stroke-width', '2');
        canvas.append(line);
        var pointWitdhGap = (canvas.attr('width') - 2*sideGap) / (paths[i -1][0].length -1);
        for (var j = 0; j < paths[i -1][0].length; j++) {
            //nakreslenie bodu pre vrchol j na ceste i
            var circle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
            circle.setAttribute('cx', sideGap + j*pointWitdhGap);
            circle.setAttribute('cy', lineHeightGap*i - downGap - lineHeightGap/pathsCount );
            circle.setAttribute('r', circleR);
            circle.setAttribute('stroke', 'rgb(0,0,0)');
            circle.setAttribute('stroke-width', '2');
            circle.setAttribute('fill', 'rgb(0,0,0)');
            canvas.append(circle);
            //vypisanie prikazu pre vrchol j na ceste i
            var text = document.createElementNS('http://www.w3.org/2000/svg', 'text');
            text.setAttribute('x', sideGap + j*pointWitdhGap);
            text.setAttribute('y', lineHeightGap*i - upperTextGap - downGap - lineHeightGap/pathsCount);
            text.setAttribute('transform', "rotate(-10 " + (sideGap + j*pointWitdhGap) + 
                " " + (lineHeightGap*i - upperTextGap) + ")");
            text.setAttribute('fill', 'rgb(0,0,0)');
            if(j == paths[i -1][0].length -1 ) text.setAttribute('text-anchor', 'middle');
            text.textContent = nodes[ways[i-1][ways[i-1].length - 1 - j]].text;
            canvas.append(text);
        };
    };
}

PathsClass.prototype.next = function () {
    var paths = PathsClass.prototype.paths;
    var nodes = PathsClass.prototype.nodes;
    var ways = PathsClass.prototype.ways;

    if(PathsClass.prototype.iteratorJ == 0 ){
        PathsClass.prototype.iteratorJ = paths[PathsClass.prototype.iteratorI][0].length -1;
        if(PathsClass.prototype.iteratorI == PathsClass.prototype.paths.length){
            return -1;
        }
        PathsClass.prototype.iteratorI++;
    } else {
        PathsClass.prototype.iteratorJ--;  
    }

    var i = PathsClass.prototype.iteratorI;
    var j = PathsClass.prototype.iteratorJ;

    var canvas = $('#visualizationSvg');
    var pathsCount = paths.length;
    var sideGap = 100;
    var downGap = 50;
    var upperTextGap = 20;
    var downTextGap = 20;
    var circleR = 6;

    var lineHeightGap = (canvas.attr('height') / pathsCount) ;
    var pointWitdhGap = (canvas.attr('width') - 2*sideGap) / (paths[i -1][0].length -1);

    var text = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    text.setAttribute('x', sideGap + j*pointWitdhGap);
    text.setAttribute('y', lineHeightGap*i + downTextGap - downGap - lineHeightGap/pathsCount);
    text.setAttribute('fill', 'rgb(0,0,0)');
    text.setAttribute('transform', "rotate(10 " + (sideGap + j*pointWitdhGap) + 
        " " + (lineHeightGap*i - upperTextGap) + ")");
    text.textContent = "R(" + paths[i-1][0][ways[i-1].length - 1 - j] + ")";
    canvas.append(text);

    var text = document.createElementNS('http://www.w3.org/2000/svg', 'text');
    text.setAttribute('x', sideGap + j*pointWitdhGap);
    text.setAttribute('y', lineHeightGap*i + downTextGap - downGap + 12 - lineHeightGap/pathsCount);
    text.setAttribute('transform', "rotate(10 " + (sideGap + j*pointWitdhGap) + 
        " " + (lineHeightGap*i - upperTextGap) + ")");
    text.setAttribute('fill', 'rgb(0,0,0)');
    text.textContent = "r(" + paths[i-1][1][ways[i-1].length - 1 - j] + ")";
    canvas.append(text);

    if(j < paths[i-1][0].length-1){
        createArrow(canvas, sideGap + (j+1)*pointWitdhGap,sideGap + (j)*pointWitdhGap + circleR,
           lineHeightGap*i - downGap- lineHeightGap/pathsCount);    
    }
    
    return 0;
}

function createArrow(canvas,x1,x2,y) {


    var svgNS = "http://www.w3.org/2000/svg";

    var lineData = [
    { "x": x1, "y": y},
    { "x": (x1+x2)/2, "y": (y+ 20)},
    { "x": x2, "y": y}
    ];

    var newPath = document.createElementNS(svgNS,"path");
    newPath.setAttribute("class", "link");
    newPath.setAttribute("stroke", "black");
    newPath.setAttribute("stroke-width", 2);
    newPath.setAttribute("fill", "none");
    newPath.setAttribute("d", lineFunction(lineData));
    canvas.append(newPath);

    var leftArrowLine = document.createElementNS(svgNS,"line");
    leftArrowLine.setAttribute("class", "link");
    leftArrowLine.setAttribute("stroke", "black");
    leftArrowLine.setAttribute("stroke-width", 2);
    leftArrowLine.setAttribute("fill", "none");
    leftArrowLine.setAttribute("x1", (x1+x2)/2);
    leftArrowLine.setAttribute("y1", (y+ 20 -7));
    leftArrowLine.setAttribute("x2", (x1+x2)/2 + 12);
    leftArrowLine.setAttribute("y2", (y+ 20));
    canvas.append(leftArrowLine);

    var rightArrowLine = document.createElementNS(svgNS,"line");
    rightArrowLine.setAttribute("class", "link");
    rightArrowLine.setAttribute("stroke", "black");
    rightArrowLine.setAttribute("stroke-width", 2);
    rightArrowLine.setAttribute("fill", "none");
    rightArrowLine.setAttribute("x1", (x1+x2)/2);
    rightArrowLine.setAttribute("y1", (y+ 20 -7));
    rightArrowLine.setAttribute("x2", (x1+x2)/2 + 14);
    rightArrowLine.setAttribute("y2",(y+ 20)-14);
    canvas.append(rightArrowLine);
}

var lineFunction = d3.svg.line()
.x(function (d) {
    return d.x;
})
.y(function (d) {
    return d.y;
})
.interpolate("basis");


/*
 *   -------- COMPUTING PATHS FUNCTIONS--------------------
 */
 function getVerificationConditions(ways,invariants,paths){
    var verificationConditions = [];

    for (var i = 0; i < ways.length; i++) {
        var invariant1 = getInvariantByNodeId(ways[i][ways[i].length -1], invariants);
        var invariant2 = getInvariantByNodeId(ways[i][0],invariants);

        var condition = "( " + invariant1[0] + " & " + paths[i][0][paths[i][0].length -1] + 
            " )=>( " + substitutionToInvariant(invariant2[0], paths[i]) + " )";
    verificationConditions.push(condition);
};
return verificationConditions;
}

function substitutionToInvariant(invariant, path){
    var variables = splitSubs(path[1][0]);
    var variablesToSub = splitSubs(path[1][path[1].length-1]);
    for (var i = variables.length - 1; i >= 0; i--) {
        var regex = new RegExp(variables[i] ,"g");
        invariant = invariant.replace(regex, variablesToSub[i]);
    };
    return invariant;
}

function computeWay(way, nodes, invariants, linesOfCode){
    var wayStatesR = [];
    var wayStates_r = [];
    wayStatesR[0] = "true";
    wayStates_r[0] = get_rText(getInvariantByNodeId(parseInt(way[0]), invariants));

    //end prikaz, deliaci bod je ako keby az za priakzom - vynimka 
    if(parseCommandFromString(nodes[way[0]]) == 2){
        wayStatesR[-1] = wayStatesR[0];
        wayStates_r[-1] = wayStates_r[0];
        var res = backSubstAssignment(wayStatesR[-1], wayStates_r[-1], nodes[way[0]]);
        wayStatesR[0] = res[0];
        wayStates_r[0] = res[1];
    }
    //postupne vygeneruje R a r pre kazdy prikaz na ceste
    for (var i = 1; i < way.length; i++) {
        switch(parseCommandFromString(nodes[way[i]])){
            //if prikaz
            case 0:
            wayStatesR[i] = backSubstIf(wayStatesR[i-1], nodes, way[i-1], way[i], linesOfCode);
            wayStates_r[i] = wayStates_r[i-1];
            break;
            //:= prikaz
            case 1:
            var res = backSubstAssignment(wayStatesR[i-1], wayStates_r[i-1], nodes[way[i]]);
            wayStatesR[i] = res[0];
            wayStates_r[i] = res[1];
            break;
        }
    };
    return [wayStatesR, wayStates_r];
}

function backSubstAssignment(stateR, state_r, node){
    var variablesBeforeAssignment = parseVariables(node.text.substr(0, node.text.indexOf(':=')));
    var subs = getAssignmentSubstitutes(node.text);
    for (var i = 0; i < variablesBeforeAssignment.length; i++) {
        var regex = new RegExp(variablesBeforeAssignment[i] ,"g");
        stateR = stateR.replace(regex, subs[i]);
        state_r = state_r.replace(regex, subs[i]);
        stateR = stateR.replace('&gt;', '>');
        stateR = stateR.replace('&lt;', '<');
    };
    return [stateR, state_r];
}

function backSubstIf(stateR, nodes, fromNodeIndex, toNodeIndex, linesOfCode){
    var children = LineOfCode.prototype.getChildrenOfNode(nodes[toNodeIndex],linesOfCode, nodes);
    var con = nodes[toNodeIndex].text;
    con = con.replace("if", '');
    con = con.replace(/\s+/g, '');
    if(children[0].id == fromNodeIndex){
        stateR = stateR + " & " +  con;
    } else {
        stateR = stateR + " & ¬(" + con + ")";
    }
    return stateR;
}

function getInvariantText(invariant){
    var variables = parseVariables(invariant[0]);
    return "I_" + invariant[1] + "(" + variables + ")";
}

function get_rText(invariant){
    var variables = "" + parseVariables(invariant[0]);
    return variables;
}

//vrati pole substitutov na pravej strane priradenia
function getAssignmentSubstitutes(command){
    var subs = command.substr(command.indexOf(':='));
    subs = subs.substr(subs.indexOf('[') + 1, subs.indexOf(']') - subs.indexOf('[') -1);
    var subsArr = splitSubs(subs);
    return subsArr;
}

function splitSubs(str){
    var subsArr = [];
    var sub = "";
    var leftPar = 0;
    var rightPar = 0;
    for ( var i = 0; i < str.length; i++ ){
        if(str.charAt(i) == '('){
            leftPar++;  
        } 
        if(str.charAt(i) == ')'){
            rightPar++;
        }
        if((str.charAt(i) == ',' || i == (str.length -1)) && leftPar == rightPar){
            //zalepenie posledneho znaku
            if(i == (str.length -1)) sub += str.charAt(i);
            sub = sub.replace(/\s+/g, '');
            subsArr.push(sub);
            sub = "";
        } else {
            sub += str.charAt(i);
        }
    }
    return subsArr;
}

//vrati pole premennych typu x1,y2
function parseVariables(command){
    var vars = Array();
    var regex = /(x|y|z)[0-9]*/g;
    vars = command.match(regex);
    //usporiadanie pola
    if(vars != null) vars.sort();
    return deleteDuplicates(vars);
}

function getInvariantByNodeId(id, invariants){
    var invariant = undefined;
    for (var i = 0; i < invariants.length; i++) {
        if(invariants[i][1] == id){
         invariant = invariants[i];
     } 
 }
 return invariant;
}

function deleteDuplicates(names){
    if(names == null) return [];
    var uniqueNames = [];
    $.each(names, function(i, el){
        if($.inArray(el, uniqueNames) === -1) uniqueNames.push(el);
    });
    return uniqueNames;
}

function parseCommandFromString(node){
    if(node.text.indexOf("end") >= 0) return 2;
    if(node.text.indexOf("if") >= 0) return 0;
    if(node.text.indexOf(":=") >= 0) return 1;
}