function ParserClass() {

    var treeData = "";

    var linesOfCode = new Array();
    var countExtraNodes = 0;
    var arraySize = 0;

    var self = this;

    this.Commands = {
        BEGIN: 0,
        IS: 1,
        GOTO: 2,
        IF_GOTO:3,
        IF_IS:4,
        END:5
    }

    // je to zavisle na getTreeJSOFromString??
    ParserClass.prototype.getLinesOfCode = function(nodes, input){
        var inputWithoutSpaces = input.replace("&nbsp;","");
        makeLinks(nodes, inputWithoutSpaces);
        return linesOfCode;
    }

    this.getLinks = function (nodes, input){
        return makeLinks(nodes, input);
    }

    this.getTreeJSOFromString = function (input) {
        var rows = input.split('\n');
        var valideProg = searchForErrorsInCode(rows);
        if (!valideProg){
            return -1;
        }
        rec(rows, 0);
        return treeData;
    }

    function makeLinks(nodes, input){
        var downLinks = new Array();
        for(var i in linesOfCode){
            if(linesOfCode[i].childrenLineOfCodes.length == 1){
                downLinks.push({source: nodes[linesOfCode[i].nodes[0]], target: nodes[linesOfCode[linesOfCode.length -1 - linesOfCode[i].childrenLineOfCodes[0]].nodes[0]]});
            } else if(linesOfCode[i].childrenLineOfCodes.length == 2){
                //kontrola ci nie je end v childrenLineOfCodes
                if(linesOfCode[i].childrenLineOfCodes[0] != 'end'){
                    if(linesOfCode[i].nodes.length != 2) { // vetva else sa vykona ak command.if_is
                        downLinks.push({source: nodes[linesOfCode[i].nodes[0]], target: nodes[linesOfCode[linesOfCode.length -1 - linesOfCode[i].childrenLineOfCodes[0]].nodes[0]]});
                    } else {
                        downLinks.push({source: nodes[linesOfCode[i].nodes[0]], target: nodes[linesOfCode[i].nodes[1]]});
                        downLinks.push({source: nodes[linesOfCode[i].nodes[1]], target: nodes[linesOfCode[linesOfCode.length -1 - linesOfCode[i].childrenLineOfCodes[1]].nodes[0]]});
                    }
                } else {
                    downLinks.push({source: nodes[linesOfCode[i].nodes[0]], target: nodes[linesOfCode[0].nodes[0]]});
                }
                downLinks.push({source: nodes[linesOfCode[i].nodes[0]], target: nodes[linesOfCode[linesOfCode.length -1 - linesOfCode[i].childrenLineOfCodes[1]].nodes[0]]});
            }
        }
        return downLinks;
    }

    function searchForErrorsInCode(rows) {
        if (!(rows[0].toLowerCase().indexOf("begin") >= 0)) {
            window.alert("Wrong input, first line must contain begin word");
            return false;
        }

        if (!(rows[rows.length - 1].toLowerCase().indexOf("end") >= 0)) {
            window.alert("Wrong input, last line must contain begin word");
            return false;
        }

        for (var row in rows) {
            if (!(rows[row].toLowerCase().indexOf("begin") >= 0 ||
                rows[row].toLowerCase().indexOf(":=") >= 0 ||
                rows[row].toLowerCase().indexOf("if") >= 0 ||
                rows[row].toLowerCase().indexOf("goto") >= 0 ||
                rows[row].toLowerCase().indexOf("end") >= 0)) {
                window.alert("Wrong input, error occurred in " + parseInt(row) + " line");
                return false;
            }
        }
        return true;
    }

    function getNumberFromString(str) {

        var res = str.split(" ");
        for (var key in res) {
            if (res[key].toLowerCase().indexOf("end") >= 0) return "end";
            if (!isNaN(res[key]) && res[key].length > 0) {
                return res[key];
            }
        }
        return false;
    }

    function parseCommandFromString(str){ // zalezi na poradi ifov
        if(str.indexOf("begin") >= 0) return self.Commands.BEGIN;
        if(str.indexOf("end") >= 0 && !(str.indexOf("goto") >= 0)) return self.Commands.END;
        if(str.indexOf("if") >= 0) if(str.indexOf(":=") >= 0) return self.Commands.IF_IS; else return self.Commands.IF_GOTO;
        if(str.indexOf(":=") >= 0) return self.Commands.IS;
        if(str.indexOf("goto") >= 0) return self.Commands.GOTO;
    }

    function rec(rows, i) {
        if (i >= rows.length) return;

        var command = parseCommandFromString(rows[i].toLowerCase());
        var lineOfCode = new LineOfCode(i,command);
        var nextCommandIsGOTO = false;
        if(rows.length-1 > i ) {
            if (parseCommandFromString(rows[i+1].toLowerCase()) == self.Commands.GOTO)
                nextCommandIsGOTO = true;
        }
        switch (command){
            case self.Commands.BEGIN:
                lineOfCode.nodes.push(i + countExtraNodes);
                treeData += '{name: "B", id:"'+ (i+ countExtraNodes) +'", class:"begin", text:"'+ rows[i] +'", contents: [';
                if(!nextCommandIsGOTO){
                    lineOfCode.childrenLineOfCodes.push(i + 1);
                } else {
                    lineOfCode.childrenLineOfCodes.push( getNumberFromString(rows[i+1]));
                }
                rec(rows, ++i);
                treeData += ']}';
                break;
            case self.Commands.END:
                lineOfCode.nodes.push(i + countExtraNodes);
                treeData += '{name:"E", id:"'+ (i+ countExtraNodes) +'",  class:"end", text:"'+ rows[i] +'", link:"end.png"}';
                break;
            case self.Commands.IF_GOTO:
                lineOfCode.nodes.push(i + countExtraNodes);
                treeData += '{name: "IF", id:"'+ (i+ countExtraNodes) +'", text:"'+ rows[i].substr(0,rows[i].indexOf("then")) +
                    '", class: "if ifgoto", contents: [ ';
                lineOfCode.childrenLineOfCodes.push(getNumberFromString(rows[i]));
                if(!nextCommandIsGOTO) {
                    lineOfCode.childrenLineOfCodes.push(i + 1);
                } else {
                    lineOfCode.childrenLineOfCodes.push( getNumberFromString(rows[i+1]));
                }
                rec(rows, ++i);
                treeData += ']}';
                break;
            //deti tu budu mat rovnake cislo co dava logiku, lebo oba nody su v rovnakom riadku!
            case self.Commands.IF_IS:
                lineOfCode.nodes.push(i + countExtraNodes);
                lineOfCode.nodes.push(i + 1 + countExtraNodes);
                //oba vrcholy maju rovnake dieta vzdy!
                lineOfCode.childrenLineOfCodes.push(i);
                treeData += '{name: "IF", id:"'+ (i+ countExtraNodes) +'", text:"'+ rows[i].substr(0,rows[i].indexOf("then")) +
                    '", class: "if ifis", contents: [ {name:":=", id:"'+ (i+ 1 + countExtraNodes) +'", text:"'+
                    rows[i].substr(rows[i].indexOf("then") + 4, rows[i].length -1) +'",class:"is"},';
                countExtraNodes++;
                if(!nextCommandIsGOTO){
                    lineOfCode.childrenLineOfCodes.push(i + 1);
                } else {
                    lineOfCode.childrenLineOfCodes.push( getNumberFromString(rows[i+1]));
                }
                rec(rows, ++i);
                treeData += ']}';
                break;
            case self.Commands.IS:
                lineOfCode.nodes.push(i + countExtraNodes);
                treeData += '{name: ":=", id:"'+ (i + countExtraNodes) +'", text:"'+ rows[i] +'", class:"is",contents: [';
                if(!nextCommandIsGOTO){
                    lineOfCode.childrenLineOfCodes.push(i + 1);
                } else {
                    lineOfCode.childrenLineOfCodes.push( getNumberFromString(rows[i+1]));
                }
                rec(rows, ++i);
                treeData += ']}';
                break;
            case self.Commands.GOTO:
                countExtraNodes--;
                rec(rows, ++i);
                break;
        }
        linesOfCode.push(lineOfCode);
    }
}