from flask import request, g
import os

from app import app, db
from .models import Admin, Problem, Submit
from .utils import api_key_auth, validate_submit, store_submit_file
from tasks import send_submit_to_test_queue


@app.route('/')
@app.route('/index')
def index():
    return "Hello, Testovac!"


@app.route('/users')
def users():
    return ','.join(x.username for x in Admin.query.all())


@app.route('/submit', methods=['POST'])
@api_key_auth
@validate_submit
def submit():
    submit = Submit(
        uid=g.uid,
        client=g.client,
        problem=g.problem,
        language=g.language,
        priority=g.priority
    )
    db.session.add(submit)
    db.session.commit()

    temp_filepath = os.path.join(
        app.config['TEMP_FOLDER'], f'{g.client.name}/{g.uid}.{g.language.value}'
    )
    g.submission_file.save(temp_filepath)
    store_submit_file(submit, temp_filepath)
    send_submit_to_test_queue(submit)
    return g.uid
