#!/usr/bin/python3
import sys, os, subprocess, configparser, shutil, imp, postgresql

def report_message(message, also_stdout=True):
    global compile_logfile
    if also_stdout:
        try:
            print(message.encode('utf-8'))
        except:
            print('failed to print message to stdout (weird chars?)')
    handle = open(compile_logfile, encoding='utf-8', mode='w')
    handle.write(message)
    handle.write('\n')
    handle.close()

def write_tresult(result):
    global test_result_file
    f = open(test_result_file,'w')
    f.write(result)
    f.close()

def get_ksp_info(sender,task):
    try:
        assert sender[:4]=='KSP-'
        assert task[:4]=='KSP-'
        sender_id, task_id = int(sender[4:]), int(task[4:])
        db = postgresql.open( user='kasparweb', password='styrycytrony', database='kaspar', host='10.0.0.2', port=5432, connect_timeout=5 )
        row = db.prepare("SELECT * FROM people WHERE man_id={};".format(sender_id)).first()
        sender_name = row['firstname'] + ' ' + row['lastname']
        row = db.prepare("SELECT * FROM tasks WHERE task_id={};".format(task_id)).first()
        task_name = str(row['num']) + ' ' + row['name']
        return (sender_name,task_name)
    except:
        return ('','')

def process(rootdir,submit_basename):
    global compile_logfile, test_result_file
    bindir, tasksdir, spooldir, tmpdir = rootdir+'/bin/', rootdir+'/tasks/', rootdir+'/spool/', rootdir+'/tmp/'
    compile_logfile = tmpdir+'/'+submit_basename+'.clog'
    test_result_file = tmpdir+'/'+submit_basename+'.tresult'

    box = subprocess.check_output( [ bindir+'/isolate', '--init' ] )
    box = str( box.strip(), 'utf-8', errors='ignore' )
    # FIXME tu by mohla byt assertion, ci je to ten, co chceme

    cfg = configparser.RawConfigParser()
    try:
        tmp = cfg.read(spooldir+'/'+submit_basename+'.config')
        assert len(tmp)==1
        submit = dict( cfg.items('submit') )
    except:
        # nesparsoval config
        report_message('INTERNAL ERROR: failed to parse the config file of the submission.')
        write_tresult('IN')
        subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
        return False

    if submit['contest'] == 'LIAHEN3':
        tasksdir = rootdir+'/tasks-liahen/'

    taskdir = tasksdir+'/'+submit['task']+'/'
    if not os.path.isdir(taskdir):
        report_message('INTERNAL ERROR: task directory missing.')
        write_tresult('IN')
        subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
        return False

    taskcfg = taskdir+'metadata.config'
    if not os.path.isfile(taskcfg):
        report_message('INTERNAL ERROR: task config missing.')
        write_tresult('IN')
        subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
        return False

    cfg = configparser.RawConfigParser()
    try:
        tmp = cfg.read(taskcfg)
        assert len(tmp)==1
        task = dict( cfg.items('task') )
    except:
        # nesparsoval config
        report_message('INTERNAL ERROR: failed to parse the config file of the task.')
        write_tresult('IN')
        subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
        return False

    if 'custom_compile' in task:
        module_name = task['custom_compile']
        if module_name.endswith('.py'): module_name = module_name[:-3]
        mfile, mpath, mdesc = imp.find_module( module_name, [taskdir] )
        print(mpath)
        modul = imp.load_module('custom_compile', mfile, mpath, mdesc)
        return modul.custom_process(rootdir,submit_basename)

    if submit['contest']=='KSP':
        yellow, gray = '\033[1;33m', '\033[0;37m'
        # sender_name,task_name = get_ksp_info( submit['sender'], submit['task'] )
        # print( 'sender: {}{}{}  task: {}{}{}'.format(yellow,sender_name,gray,yellow,task_name,gray) )

    submit_filename = submit['task']+'.'+submit['language']
    shutil.copy( spooldir+'/'+submit_basename+'.data', box+'/box/'+submit_filename )

    # FIXME z metadat zistit co vsetko este nakopirovat do sandboxu a nakopirovat to tam
    # FIXME z metadat zistit ci nemame custom commands na kompilaciu

    cmdline = []
    cmdline.append( bindir+'/isolate' )
    cmdline.append( '--meta='+tmpdir+'/'+submit_basename+'.cmeta' )
    cmdline.append( '--mem=2925000' )
    cmdline.append( '--time=20' )
    cmdline.append( '--wall-time=30' )
    cmdline.append( '--dir=/etc' )
    cmdline.append( '--dir=/usr/lib/ghc' )
    cmdline.append( '--dir=/var/lib/ghc' )
    cmdline.append( '--processes' )
    # FIXME tu by este mali ist control groups
    cmdline.append( '--env=PATH=/usr/bin' )
    cmdline.append( '--env=MONO_SHARED_DIR=/tmp' )
    cmdline.append( '--run' )
    cmdline.append( '--' )

    compilation_needed = True
    unknown_language = True

    if submit['language'] == 'c':
        unknown_language = False
        cmdline.append( '/usr/bin/gcc' )
        cmdline.append( '-static' )
        cmdline.append( '-std=gnu99' )
        cmdline.append( '-O2' )
        cmdline.append( '-Wall' )
        cmdline.append( '-Wextra' )
        cmdline.extend( ['-o','binarka'] )
        cmdline.append( submit_filename )
        cmdline.append( '-lm' )

    if submit['language'] in ['cc','cpp']:
        unknown_language = False
        cmdline.append( '/usr/bin/g++' )
        cmdline.append( '-static' )
        cmdline.append( '-std=gnu++17' )
        cmdline.append( '-O2' )
        cmdline.append( '-Wall' )
        cmdline.append( '-Wextra' )
        cmdline.extend( ['-o','binarka'] )
        cmdline.append( submit_filename )

    if submit['language'] == 'd':
        unknown_language = False
        cmdline.append( '/usr/bin/gdc' )
        cmdline.append( '-static' )
        cmdline.append( '-O2' )
        cmdline.append( '-Wall' )
        cmdline.append( '-Wextra' )
        cmdline.extend( ['-o','binarka'] )
        cmdline.append( submit_filename )

    if submit['language'] == 'py':
        unknown_language = False
        cmdline.append( '/usr/bin/python3' )
        cmdline.append( '-m' )
        cmdline.append( 'py_compile' )
        cmdline.append( submit_filename )

    if submit['language'] == 'pl':
        unknown_language = False
        cmdline.append( '/usr/bin/perl' )
        cmdline.append( '-w' )
        cmdline.append( '-c' )
        cmdline.append( submit_filename )

    if submit['language'] == 'hs':
        unknown_language = False
        cmdline = cmdline[:8] + [ '--dir=/tmp/box/0/box:rw' ] + cmdline[8:]
        cmdline.append( '/usr/bin/ghc' )
        cmdline.append( '-static' )
        cmdline.append( '-rtsopts' )
        cmdline.append( '-tmpdir' )
        cmdline.append( '/tmp/box/0/box' )
        cmdline.append( '--make' )
        cmdline.append( submit_filename )
        cmdline.append( '-O2' )
        cmdline.append( '-Wall' )
        cmdline.extend( ['-o','binarka'] )

    if submit['language'] == 'pas':
        unknown_language = False
        cmdline.append( '/usr/bin/fpc' )
        cmdline.append( submit_filename )
        cmdline.append( '-Sg' )
        cmdline.append( '-O1' )
        cmdline.append( '-obinarka' )

    if submit['language'] == 'dpr':
        unknown_language = False
        cmdline.append( '/usr/bin/fpc' )
        cmdline.append( submit_filename )
        cmdline.append( '-Sg' )
        cmdline.append( '-Sd' )
        cmdline.append( '-O1' )
        cmdline.append( '-obinarka' )

    if submit['language'] == 'java':
        unknown_language = False
        cmdline.append( '/usr/bin/javac' )
        cmdline.append( submit_filename )

    if submit['language'] == 'cs':
        unknown_language = False
        subprocess.call( [bindir+'/kill_mono_semaphores.sh'] )
        # cmdline.append( '/usr/bin/gmcs' )
        cmdline.append( '/usr/bin/mcs' )
        cmdline.append( submit_filename )

    if submit['language'] == 'lisp':
        unknown_language = False
        cmdline.append( '/usr/bin/sbcl' )
        cmdline.append( '--noinform' )
        cmdline.append( '--eval' )
        cmdline.append( '(compile-file "{}")'.format(submit_filename) )
        cmdline.append( '--eval' )
        cmdline.append( '(quit)' )

    if submit['language'] in ['zip','gz','tgz','txt','js','clj']:
        unknown_language = False
        compilation_needed = False

    if unknown_language:
        report_message('INTERNAL ERROR: unknown language.')
        write_tresult('IN')
        subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
        return False

    if not compilation_needed:
        report_message('',False)
        subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
        return True

    try:
        out = subprocess.check_output( cmdline, stderr=subprocess.STDOUT )
        err = 0
    except subprocess.CalledProcessError as exc:
        out = exc.output
        err = exc.returncode
        # FIXME skontrolovat ci nejde o compilation time limit

    # skus skopirovat binarku vyrobenu pre kompilovane jazyky
    try: shutil.copy( box+'/box/binarka', tmpdir )
    except: pass # neni binarka => neskopirujeme :)

    # skus skopirovat classy vyrobene javou
    for classa in sorted(os.listdir(box+'/box/')):
        if not (classa.endswith('.class')): continue
        try: shutil.copy( box+'/box/'+classa, tmpdir )
        except: pass # nemalo by nastat

    # skus skopirovat exe vyrobene c#
    try: shutil.copy( box+'/box/'+submit['task']+'.exe', tmpdir+'/binarka.exe' )
    except: pass

    out = str(out, 'utf-8', errors='replace')
    if len(out)>10000:
        out = out[:10000] + '\n\n(Compiler output too long, truncated.)\n'
    report_message(out,False)
    # subprocess.call( [ bindir+'/isolate', '--cleanup' ] )
    if err != 0:
        print('Final result: --> \033[1;31mCE\033[0;37m <--')
        write_tresult('CE')
    return err == 0

############################################################################################

if __name__=="__main__":
    # toto sa normalne nevykonava, je to tu len na testovanie
    if len(sys.argv)>1:
        res = process('/home/testovac',sys.argv[1])
        print('done: {}'.format(res))

