from enum import Enum
import os

from settings import (
    OUTPUT_DIRECTORY,
    TASK_DIRECTORY,
    TEMP_DIRECTORY,
)


class TestingMode(Enum):
    def __str__(self):
        return str(self.value)

    ACM = 'acm'
    ALL = 'all'
    # not snake_case for backwards compatibility
    TESTALL = 'testall'
    BATCH = 'batch'


class TestingStatus(Enum):
    def __str__(self):
        return str(self.value)

    IN_QUEUE = 'IQ'
    OK = 'OK'
    WRONG_ANSWER = 'WA'
    TIME_LIMIT_EXCEEDED = 'TO'
    SECURITY_EXCEPTION = 'SE'
    INTERNAL_ERROR = 'IE'
    RUNTIME_EXCEPTION = 'RE'
    COMPILATION_ERROR = 'CE'
    COMPILATION_TIME_EXCEEDED = 'CTE'
    IGNORED = 'IG'


TASK_CONFIG_PATH = os.path.join(TASK_DIRECTORY, 'task.config')
COMPILATION_LOG_PATH = os.path.join(OUTPUT_DIRECTORY, 'submit.clog')
COMPILATION_METADATA_PATH = os.path.join(OUTPUT_DIRECTORY, 'compiler.isometa')

MAX_COMPILER_OUTPUT_LENGTH = 10000
COMPILATION_CPU_TIME_LIMIT_SECONDS = 20
COMPILATION_WALL_TIME_LIMIT_SECONDS = 30
COMPILATION_MAX_NUMBER_OF_PROCESSES = 16
COMPILATION_MEMORY_LIMIT_KILOBYTES = 2925000

EXECUTION_MAX_NUMBER_OF_PROCESSES = 16
EXECUTION_TEMP_METADATA_PATH = os.path.join(TEMP_DIRECTORY, 'submit.hmeta')
EXECUTION_INPUT_FILE_NAME = 'test.in'
EXECUTION_OUTPUT_FILE_NAME = 'test.out'

TEST_PROTOCOL_PATH = os.path.join(OUTPUT_DIRECTORY, 'submit.tlog')
TEST_RESULT_STATUS_PATH = os.path.join(OUTPUT_DIRECTORY, 'submit.tresult')
BATCH_RESULTS_PATH = os.path.join(OUTPUT_DIRECTORY, 'submit.bresult')

DEFAULT_EXECUTION_MEMORY_LIMIT_KILOBYTES = 256000
