import os

from compile_submit import compile_submit
from execute import execute_submit
from utils import is_environment_ready
import isolate
from constants import TestingStatus

if __name__ == '__main__':
    if is_environment_ready():
        sandbox_path = os.path.join(isolate.initialise_sandbox(), 'box/')
        if compile_submit(sandbox_path):
            result_status = execute_submit(sandbox_path)
        else:
            result_status = TestingStatus.COMPILATION_ERROR
        isolate.cleanup_sandbox()
    else:
        result_status = TestingStatus.INTERNAL_ERROR
    print(result_status)
