#!/usr/bin/perl
use strict;
use warnings;

my $chars = '0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOASDFGHJKLZXCVBNM';
sub randchar {
    return substr($chars, int(rand(length $chars)), 1);
}

sub randchars {
    my $t='';
    $t .= randchar foreach 1 .. shift;
    return $t;
}

sub plaintext {
    print randchars(100*$_), "\n" foreach 1 .. shift;
}

sub alternatives {
    foreach my $i (1 .. shift) {
        my $t=randchars(100*$i);
        print substr($t, $_*100, 100), $_!=$i-1?"|":"\n" foreach 0 .. $i-1;
    }
}

sub braces {
    print "a.{$_}a\n" foreach 1 .. shift;
}

sub matching {
    die "need 3 params" if @_!=3;
    my @alt;
    foreach (1 .. $_[0]) {
        my $t=randchars(40+int(rand(20)));
        print STDERR $t, $_!=$_[0]?"|":"\n";
        push(@alt, $t);
    }

    foreach my $i (1 .. $_[1]) {
        unless(rand(1)<$_[2]) {
            print randchars(90+int(rand(20))), "\n";
        } else {
            my $t=$alt[int(rand($_[0]))];
            my $str=randchars(40+int(rand(20)));
            my $pos=int(rand(length($str)+1));
            print substr($str, 0, $pos), $t, substr($str, $pos, 100), "\n";
        }
    }
}

$_=shift;
plaintext(shift) if /^plaintext$/i;
alternatives(shift) if /^alternatives$/i;
braces(shift) if /^braces$/i;
matching(@ARGV) if /^matching$/i;
