# CHECK_ARGS(LANGUAGE, SHELL-VAR, LIST)
# check if compiler for LANGUAGE supports
# command-line arguments given in the LIST
# and adds supported args get added to SHELL-VAR
# ----------------------------------------------------------
AC_DEFUN([CHECK_ARGS],
[
        AC_LANG_PUSH([$1])
        case $1 in
                C)
                        CHECK_ARGS_COMPILER_var=CC
                        CHECK_ARGS_COMPILER_FLAGS_var=CFLAGS
                ;;
                C++)
                        CHECK_ARGS_COMPILER_var=CXX
                        CHECK_ARGS_COMPILER_FLAGS_var=CXXFLAGS
                ;;
        esac
	CHECK_ARGS_COMPILER_FLAGS=${!CHECK_ARGS_COMPILER_FLAGS_var}
	for i in $3; do
		eval ${CHECK_ARGS_COMPILER_FLAGS_var}=\'${CHECK_ARGS_COMPILER_FLAGS} ${i}\'
		AC_MSG_CHECKING([if ${!CHECK_ARGS_COMPILER_var} accepts ${i}])
		AC_COMPILE_IFELSE([AC_LANG_PROGRAM([], [])], [
AC_MSG_RESULT([yes])
$2="${$2} ${i}"
], [AC_MSG_RESULT([no])])
	done
        eval ${CHECK_ARGS_COMPILER_FLAGS_var}=\'${CHECK_ARGS_COMPILER_FLAGS}\'
        AC_LANG_POP([$1])
])
