#ifndef FOOGREP_REGEX_HH
#define FOOGREP_REGEX_HH

#include <string>
#include <exception>
#include <vector>
#include <map>
#include <set>

#include <iosfwd>

class regex_state;

class regex {
public:
    enum { INTERVAL_MAX=UINT16_MAX };
    enum { 
        MATCH_PARTIAL=0x00, MATCH_FULL=0x01,
        MATCH_CASE_SENSITIVE=0x00, MATCH_CASE_INSENSITIVE=0x02,
    };

private:
    uint32_t flags;
    std::vector<regex_state *> states;

    regex_state* new_state();
public:
    class exception_parse: public std::exception {
        std::string::size_type pos;
    public:
        exception_parse(std::string::size_type pos_)
            : std::exception(), pos(pos_)
        {}

        virtual const char* what() const throw()
        { return "Parse error!"; }

        virtual void print(std::ostream &os, const std::string &str);
    };
    class exception_unmatched: public exception_parse {
    public:
        exception_unmatched(std::string::size_type pos_)
            : exception_parse(pos_)
        {}
    };
    class exception_bad_escape: public exception_parse {
    public:
        exception_bad_escape(std::string::size_type pos_)
            : exception_parse(pos_)
        {}
    };
    class exception_bad_interval: public exception_parse {
    public:
        exception_bad_interval(std::string::size_type pos_)
            : exception_parse(pos_)
        {}
    };

    regex(const std::string &str, uint32_t flags_=0,
            std::ostream *nfa_str=NULL, std::ostream *dfa_str=NULL);
    ~regex();

    bool match(const std::string &str) const;
};

#endif
