/*
 *      imageConvert.cpp -- Kapture
 *
 *      Copyright (C) 2006-2009
 *          Detlev Casanova (detlev.casanova@gmail.com)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <QImage>
#include <QColor>

#include <sstream>
#include <string>
#include <fstream>

using namespace std;

#include "imageconvert.h"

#undef MIN
#undef MAX
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))

#define YUV2RGB(y,u,v,r,g,b) \
	(r) = ( ( (y) << 8 ) 			   + 359 * ( (v) - 128 ) ) >> 8; \
	(g) = ( ( (y) << 8 ) -  88 * ( (u) - 128 ) - 183 * ( (v) - 128 ) ) >> 8; \
        (b) = ( ( (y) << 8 ) + 456 * ( (u) - 128 ) 			 ) >> 8

/*#define YUV2RGB(y,u,v,r,g,b) \
        (r) = (y);  \
        (g) = (y); \
        (b) = (y);*/


#define STORERGB(r,g,b) \
	r  = MAX(0, MIN(255, (r))); \
	g  = MAX(0, MIN(255, (g))); \
	b  = MAX(0, MIN(255, (b)))

#define STOREGS(gs) gs  = MAX(0, MIN(255, (gs)));



#define MEAN(a,b)\
	(((a) + (b)) / 2)

unsigned char jpeg_dht[0x1a4] = {
    0xff, 0xc4, 0x01, 0xa2,

    0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,

    0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,

    0x10, 0x00, 0x02, 0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05, 0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7d,
    0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
    0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08, 0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
    0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
    0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
    0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
    0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
    0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
    0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xf9, 0xfa,0x11, 
    
    0x00, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01, 0x02, 0x77,
    0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21, 0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71,
    0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91, 0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
    0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34, 0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26,
    0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
    0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
    0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3,
    0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda,
    0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xf9, 0xfa
};

int mjpegToJpeg(unsigned char *inFrame, unsigned char *outFrame, unsigned int bufSize)
{
	unsigned int j = 0, has_dht = 0;

	outFrame[0] = inFrame[0];
	outFrame[1] = inFrame[1];
	
	if((inFrame[0] != 0xff) && (inFrame[1] != 0xd8))
	{
		printf("Not a JPEG nor MJPEG file \nExiting.\n");
		return EXIT_FAILURE;
	}

	unsigned int pos = 2, size = 0; // move into the image's table
	
	while (has_dht == 0)
	{
		if (inFrame[pos] != 0xff)
		{
#ifdef DEBUG
			printf("This isn't a valid JPEG file.\n");
#endif
			return EXIT_FAILURE;
		}
			
		if (inFrame[pos+1] == 0xc4)
		{
			has_dht = 1;
		}
		else if (inFrame[pos+1] == 0xda) // Add the huffman tables here...
		{
			has_dht = 0;
			break;
		}

		// Skip to the next marker
		size = (inFrame[pos+2] << 8) + inFrame[pos+3];
		for (j = 0; j < size + 2; j++)
		{
			outFrame[pos + j] = inFrame[pos + j];
		}
		pos = pos + size + 2;
	}
	
	j = 0;
	
	if (has_dht == 0)
	{
		for ( ; j < 420 ; j++)
		{
			outFrame[pos + j] = jpeg_dht[j];
		}
		
		for ( ; pos < bufSize ; pos++)
		{
			outFrame[pos + 420] = inFrame[pos];
		}

	}
	else
	{
		for ( ; pos < bufSize ; pos++)
		{
			outFrame[pos] = inFrame[pos];
		}
	}
	
	return EXIT_SUCCESS;
}

int yuvToJpeg(unsigned char *inFrame, QImage *outFrame, int width, int height)
{
	QImage *image = new QImage(width, height, QImage::Format_RGB32);
	const int size = width * height;
	int y, u, v, y2, u2, v2, r, g, b;
	int i = 2;
	int j = 4;
	int w = 1, h = 0;

	y = inFrame[0];
	u = inFrame[1];
	y2 = inFrame[2];
	v = inFrame[3];

    YUV2RGB(y, u, v, r, g, b);
	STORERGB(r, g, b);
	image->setPixel(w, h, qRgb(r, g, b));
	
	while(i <= size / 2)
	{
		u2  = inFrame[j+1];
		v2   = inFrame[j+3];
                YUV2RGB(y2, MEAN(u, u2), MEAN(v, v2), r, g, b);
		STORERGB(r, g, b);
		
		if (w == width)
		{
			w = 0;
			h++;
		}
		image->setPixel(w, h, qRgb(r, g, b));
		w++;
		
		y  = inFrame[j+0];
		y2 = inFrame[j+2];
		u = u2;
		v = v2;

		YUV2RGB(y, u, v, r, g, b);
		STORERGB(r, g, b);
		
		if (w == width)
		{
			w = 0;
			h++;
		}
		image->setPixel(w, h, qRgb(r, g, b));
		w++;

		i++;
		j+=4;
	}

	*outFrame = image->copy(QRect(0, 0, width, height));
	delete image;
	return 0;
}

GrayScaleImage::ImageBuffer yuvToBW(unsigned char *inFrame, int width, int height)
{        
        const int size = width * height;        
        GrayScaleImage::ImageBuffer image;
        image.resize(size);


        for(int i = 0;i<size;i++)
        {
            image[i]=inFrame[2*i];
        }

        return image;
}


ColorImage::ImageBuffer yuvToRGB(unsigned char *inFrame, int width, int height)
{
  const int size = width * height;
  ColorImage::ImageBuffer image;
  image.resize(size);
    int y, u, v, y2, u2, v2, r, g, b;
    int i = 2;
    int j = 4;

    y = inFrame[0];
    u = inFrame[1];
    y2 = inFrame[2];
    v = inFrame[3];

    YUV2RGB(y, u, v, r, g, b);
    STORERGB(r, g, b);
    image[1]=0xff000000 | (r << 16) | (g << 8) | b;

    while(i < size / 2)
    {
        u2  = inFrame[j+1];
        v2   = inFrame[j+3];
        YUV2RGB(y2, MEAN(u, u2), MEAN(v, v2), r, g, b);
        STORERGB(r, g, b);

        image[2*i]=0xff000000 | (r << 16) | (g << 8) | b;

        y  = inFrame[j+0];
        y2 = inFrame[j+2];
        u = u2;
        v = v2;

        YUV2RGB(y, u, v, r, g, b);
        STORERGB(r, g, b);

        image[2*i+1]=0xff000000 | (r << 16) | (g << 8) | b;

        i++;
        j+=4;
    }

    return image;
}
