#include "ValServerSocket.h"
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>

#include "logger.h"
using namespace std;

ValServerException::ValServerException(const char * msg){
	this->msg=string(msg);
}
const char * ValServerException::getMsg(){
	return msg.c_str();
}


void ValServerSocket::startListening(unsigned short int port){
    struct sockaddr_in serverAddr;

    serverSocket = socket(AF_INET, SOCK_STREAM, 0);
    if (serverSocket < 0) {
      throw ValServerException("server socket creation failed.");
    }

    serverAddr.sin_family = AF_INET;
    serverAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    serverAddr.sin_port = htons(port);
 	 
    if (bind(serverSocket,(struct sockaddr *) &serverAddr,sizeof(serverAddr)) < 0) {
      throw ValServerException("Cannot bind server socket.");
    }
    listen(serverSocket, 10);
	log("listening on port:",port,D_GRAN_PRODUCTION);
}


void  ValServerSocket::acceptClient(int & socket){

	socklen_t clientAddrLen;
  	struct sockaddr_in clientAddr;

    clientAddrLen = sizeof(clientAddr);
    socket = accept(serverSocket,(struct sockaddr *) &clientAddr,&clientAddrLen);
    if (socket < 0) {
      throw ValServerException("Cannot accept client socket.");
    }
	log("new client accepted",D_GRAN_TESTING);
}

void  ValServerSocket::waitData(int socket,char *buf,int len,bool &closedConnection){
	closedConnection=false;
	//TODO skontrolovat dlzku ziskanych dat!
	int res= recv(socket, buf, len, 0);		
	if(res>0){
		
	}else if(res==0){
		closedConnection=true;
	}else{
		throw ValServerException("Error while waiting for data!");
	}
}

void  ValServerSocket::sendData(int socket,char *buf,int len){
	int res=send(socket, buf, len, 0);
	//TODO skontrolovat dlzku ziskanych dat!
	if(res<0){
		throw ValServerException("Error while sending data.");	
	}
	log("sending data=",buf,D_GRAN_TESTING);
}

void  ValServerSocket::closeSocket(int socket){
		close(socket);
}
