package core;

import java.util.LinkedList;
import java.util.ListIterator;

public class CyclicGame {

	private LinkedList<Double> history;

	private double[] sequence;

	private int numSteps = 30;

	private int n;

	public CyclicGame(int n) {
		super();
		// TODO Auto-generated constructor stub
		this.n = n;
		sequence = new double[n];
		history = new LinkedList();
		for (int i = 0; i < n; i++) {
			sequence[i] = -1;
			history.add(new Double(0));
		}

	}

	public boolean checkCyclicGame(double e, int step) {
		if (step >= 0) {
			if (step == numSteps) {
				numSteps += step;
				ListIterator<Double> it = history.listIterator();
				for (int i = 0; i < n; i++) {
					sequence[i] = it.next();
				}
			}

			history.remove();
			history.add(e);
		}
		
		boolean result = true;

		ListIterator<Double> it = history.listIterator();
		for (int i = 0; i < n; i++) {
			
			if (sequence[i] != it.next())
				result = false;
		}

		return result;
	}

}
