package core;

import java.util.ArrayList;
import java.util.Vector;

public class GridGame {

	// private boolean grid[][];

	private ArrayList<Vector<Boolean>> newGrid;

	private ArrayList<Integer> horizontal;

	private int width;

	private int height;

	private int heightGame[];
	
	public boolean end;

	public GridGame(int w, int h) {
		super();
		// TODO Auto-generated constructor stub
		this.width = w;
		this.height = h;
		
		end = false;
		
		w += 4;
		h += 4;

		this.newGrid = new ArrayList(h);
		for (int i = 0; i < 3; i++) {
			Vector<Boolean> b = new Vector(w);
			for (int j = 0; j < w; j++) {
				b.add(true);
			}
			newGrid.add(b);
		}
		for (int i = 3; i < h; i++) {
			Vector<Boolean> b = new Vector(w);
			for (int j = 0; j < 2; j++) {
				b.add(true);
			}
			for (int j = 2; j < (w - 2); j++) {
				b.add(false);
			}
			for (int j = (w - 2); j < w; j++) {
				b.add(true);
			}
			newGrid.add(b);
		}

		this.horizontal = new ArrayList(this.height);
		for (int i = 0; i < this.height; i++) {
			this.horizontal.add(0);
		}

		this.heightGame = new int[w];
		for (int i = 0; i < w; i++)
			this.heightGame[i] = 0;
		for (int i = 0; i < 2; i++)
			this.heightGame[i] = h;
		for (int i = w - 2; i < w; i++)
			this.heightGame[i] = h;

		/*
		 * this.grid = new boolean[w][h]; for(int i=0; i<w; i++) for(int j=0; j<h;
		 * j++) this.grid[i][j] = false;
		 * 
		 * for(int i=0; i<2; i++) for(int j=0; j<h; j++) this.grid[i][j] =
		 * true;
		 * 
		 * for(int i=w-2; i<w; i++) for(int j=0; j<h; j++) this.grid[i][j] =
		 * true;
		 * 
		 * for(int i=0; i<w; i++) for(int j=0; j<3; j++) this.grid[i][j] =
		 * true;
		 */
	}

	public GridGame(GridGame g, Figure f) {
		// TODO Auto-generated constructor stub
		int w = 4 + g.getWidth();
		int h = 4 + g.getHeight();

		this.setWidth(w - 4);
		this.setHeight(h - 4);

		ArrayList<Vector<Boolean>> oldGrid = g.getNewGrid();

		this.newGrid = new ArrayList(oldGrid.size());
		for (int i = 0; i < oldGrid.size(); i++) {
			this.newGrid.add((Vector<Boolean>) oldGrid.get(i).clone());
		}

		this.horizontal = (ArrayList<Integer>) g.getHorizontal().clone();

		this.heightGame = new int[w];

		
		for (int i = 0; i < w; i++) {
			this.heightGame[i] = g.getHeightGame(i - 2);
		}

		int x = f.getPos().getX();
		int y = f.getPos().getY();
		GridFigure gf = f.getGrFig();

		for (int i = -2; i < 2; i++)
			for (int j = -2; j < 2; j++)
				if (gf.getValue(i, j)) {
					this.setValue(x + i, y + j, gf.getValue(i, j));
					this.setHorizontal(y + j, new Integer(this.getHorizontal(y
							+ j) + 1));
					// this.setHeightGame(x+i,this.getHeightGame(x+i)+1);
					this.setHeightGame(x + i, y + j + 1);
				}

		repair(f);

		this.end = isEnd();
	}

	private boolean isEnd() {
		for(int i=0; i<this.getWidth(); i++) {
			if(this.getHeightGame(i)>(this.getHeight()-5)) return true;
		}
		return false;
	}

	private void repair(Figure f) {
		// TODO Auto-generated method stub
		int y = f.getPos().getY();

		/*  int j = -2;
		for (int i = 0; i < 4; i++) {
			if (this.getHorizontal(j + y) >= this.width) {
				deleteLine(y + j);
			} else {
				j++;
			}

		} */
		for (int i = 1; i >-3 ; i--) {
			if (this.getHorizontal(i + y) >= this.width) {
				deleteLine(y + i);
			} 
		}

	}

	private void deleteLine(int i) {
		// TODO Auto-generated method stub
		this.horizontal.remove(i);
		this.horizontal.add(0);
		this.newGrid.remove(i + 3);
		int w = this.width + 4;
		Vector<Boolean> b = new Vector(w);
		for (int j = 0; j < 2; j++) {
			b.add(true);
		}
		for (int j = 2; j < (w - 2); j++) {
			b.add(false);
		}
		for (int j = (w - 2); j < w; j++) {
			b.add(true);
		}
		this.newGrid.add(b);
		
		for(int j=2; j<(this.width+2); j++) {
			updateHeightGame(i, j);
		}
	}

	private void updateHeightGame(int i, int j) {
		// TODO Auto-generated method stub
		if((i+1)<this.heightGame[j]) {
			this.heightGame[j]--;			
		} else {
			udpdateHeight(i,j);
		}
	}

	private void udpdateHeight(int i, int j) {
		// TODO Auto-generated method stub
		this.heightGame[j]--;			
		if(!getValue(j-2,i-1)) {
			updateHeightGame(i-1,j);
		}
	}

	public boolean getValue(int x, int y) {
		return this.newGrid.get(y + 3).get(x + 2);
		// return grid[x+2][y+3];
	}

	public void setValue(int x, int y, boolean v) {

		this.newGrid.get(y + 3).set(x + 2, new Boolean(v));
		// grid[x+2][y+3] = v;
	}

	public int getHeight() {
		return height;
	}

	public int getWidth() {
		return width;
	}

	public int getHeightGame(int x) {
		return this.heightGame[x + 2];
	}

	public void setHeightGame(int x, int v) {
		// System.out.println("ahoj");
		// System.out.println("hG:" + " x:" + x + " v:" + v);
		this.heightGame[x + 2] = Math.max(this.heightGame[x + 2], v);
	}

	public int[] getHeightGame() {
		return heightGame;
	}
	
	public int getMaxHeight() {
		int maxH = 0;
		int thisH = 0;
		for (int i = 0; i < this.width; i++) {
			thisH = this.getHeightGame(i);
			maxH = Math.max(maxH,thisH);
		}
		return maxH;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	/*
	 * 			* 
	 * bigHole *O*
	 *  			*    * 
	 *  mediumHole *O or O*
	 * 
	 * *O* smallHole *
	 * 
	 * *** surpriseHole * * O * ******
	 */

	public double evaluate() {

		int bigHole = 0;
		int mediumHole = 0;
		int smallHole = 0;
		int surpriseHole = 0;

		for (int i = 0; i < this.height; i++) {
			for (int j = 0; j < this.width; j++) {
				if (!this.newGrid.get(i + 3).get(j + 2)) {
					if (this.newGrid.get(i + 4).get(j + 2)) {
						if (this.newGrid.get(i + 3).get(j + 1)
								&& this.newGrid.get(i + 3).get(j + 3)) {
							bigHole++;
						} else {
							mediumHole++;
							/*if (this.newGrid.get(i + 3).get(j + 1)
									|| this.newGrid.get(i + 3).get(j + 3)) {
								mediumHole++;
							} else {
								surpriseHole++;
							}
							*/
						}
					} else {
						if (this.newGrid.get(i + 3).get(j + 1)
								&& this.newGrid.get(i + 3).get(j + 3)) {
							smallHole++;
						}
					}
				}
			}
		}

		int maxH = 0;
		int avgH = 0;
		int thisH = 0;
		for (int i = 0; i < this.width; i++) {
			thisH = this.getHeightGame(i);
			//System.out.print(thisH + ",");
			maxH = Math.max(maxH, thisH);
			avgH += thisH;
		}
		//System.out.println(avgH + "  max: " + maxH);
/*		if(maxH>(this.height-5)) {
			return -10;
		}
*/		
		//Random r = new Random();
		//return (50*maxH + (40*avgH)/this.width + 20*bigHole + 15*mediumHole + 12.5*smallHole);
		
		return Game.evaluate(maxH,avgH,bigHole,mediumHole,smallHole);
	}

	public ArrayList<Vector<Boolean>> getNewGrid() {
		return newGrid;
	}

	public void setHorizontal(int i, int v) {
		this.horizontal.set(i, new Integer(v));
	}

	public ArrayList<Integer> getHorizontal() {
		return horizontal;
	}

	public int getHorizontal(int i) {
		if ((i < 0) || (i >= this.height)) {
			return -1;
		}
		return this.horizontal.get(i);
	}

	public void print() {
		AppletGame.printArea("---------------" + "\n");
		System.out.println("---------------");
		for (int i = this.height - 1; i > -1; i--) {
			AppletGame.printArea("|");
			System.out.print("|");
			for (int j = 0; j < this.width; j++) {
				if (this.newGrid.get(i + 3).get(j + 2)) {
					AppletGame.printArea("*");
					System.out.print("*");
				} else {
					AppletGame.printArea(" ");
					System.out.print(" ");
				}
			}
			AppletGame.printArea("|" + "\n");
			System.out.println("|");
		}
		AppletGame.printArea("---------------" + "\n");
		System.out.println("---------------");
	}
}
