function [outputSequence internalResponse error esn] = getMSEtrain(steps, desired, forceLength, esn)
%runNetwork vypocita steps krokov siete
%Vysledkom je vystupna sekvencia outputSequence, ktora zodpoveda vystupu
%siete a internalResponse je odozva jednotlivych neuronov v case


internalResponse = zeros(length(esn.x), steps);
error = 0;

for i = 1:steps
     %save the n - th output to outputSequence
    internalResponse(:,i) = esn.x;
    outputSequence(i) = esn.y; 
    
    if (i <= forceLength)
        NetOut = desired(i);
    else
        NetOut = desired(i);
        error = error + (desired(i) - esn.y)^2;
    end
    % calculate x(n + 1)
    esn.x = unitFunction(esn.resWeights * esn.x + esn.feedbackWeights * NetOut);
    % calculate y(n + 1)
    esn.y = unitFunction(esn.outWeights * esn.x); %unitFunction(); 
end

error = error / (steps - forceLength) ;