function res = createReservoir(nUnits, connectivity)
%createReservoir Vytvorenie vah rezervoara
%  Vytvori sa riedka vahova matica dynamckeho rezervoara preskalovana na
%  spektralny radius 1.0


res = zeros(nUnits, nUnits);
nNotZeros = ceil(nUnits^2 * (connectivity / 100)); %pocet nenulovych komponentov matice


while max(abs(eig(res))) == 0
    nNotZeros = ceil(nUnits^2 * (connectivity / 100)); %pocet nenulovych komponentov matice
    res = zeros(nUnits, nUnits);
    while nNotZeros ~= 0    
        i = 1 + floor(rand * nUnits) %uint32(rand * nUnits);
        j = 1 + floor(rand * nUnits);
        if res(i, j) == 0   
            res(i, j) = rand - 0.5;     % nahodne z intervalu (-0.5 ; 0.5)
            nNotZeros = nNotZeros - 1;
        end
    end
end

% preskalovanie na spektralny radius 1
sr = max(abs(eig(res)));
res = res / sr;