function [] = ErrorGraph()
%ErrorGraph Plot network errors for various ESN parameters
%  Detailed explanation goes here

%error = zeros(5, 30);

row = 1;
col = 1;

%alphaArray = [0.5:0.05:0.75 0.8:0.025:0.95];
alphaArray = [0.6:0.02:0.99];
%alphaArray = [0.1:0.01:0.99];
esn = create_esn(20, 1, 20, 1);
% odlozenie rezervoara so spektralnym polomerom 1
reservoir = esn.resWeights;
esn = scaling(esn, 1.5);

for freq = 25%15:5:40
    for alpha = alphaArray
        %preskalovanie na pozadovany spektralny polomer
        esn.resWeights = reservoir * alpha;
       
        error(row, col) = getError(esn, freq, false);
        col = col + 1;
        error;
    end
    row = row + 1;
    col = 1;
end

plot(alphaArray, log10(error));




