function [] = ErrorGraph()
%ErrorGraph Plot network errors for various ESN parameters
%  Detailed explanation goes here

%error = zeros(5, 30);

repeat = 20;

row = 1;
col = 1;

%alphaArray = [0.5:0.05:0.75 0.8:0.025:0.95];
alphaArray = [0.6:0.02:0.99];

esn = create_esn(20, 1, 20, 1);
% odlozenie rezervoara so spektralnym polomerom 1
reservoir = esn.resWeights;
esn = scaling(esn, 1.5);

for freq = 15:5:40
    for alpha = alphaArray
        actualError = 0;

        for i = 1:repeat
            %preskalovanie na pozadovany spektralny polomer
            esn = create_esn(20, 1, 20, alpha);
            esn = scaling(esn, 1.5);    
            
            actualError = actualError + log10(getError(esn, freq, false));
        end
        error(row, col) = actualError / repeat
        col = col + 1;
    end
    row = row + 1;
    col = 1;
end

plot(alphaArray, error);




