function [outputSequence internalResponse error esn] = getMSEtest(steps, desired, forceLength, esn)
%getMSEtest - vypocita testovaciu chybu
%steps- pocet krokov ktore spravi siet (musi byt mensie ako dlzka postupnosti input a desired)
%input- vstupna postupnost
%desired- vystupna postupnost (pouzita na teacher-forcing a vypocet chyby)
%forceLength- kolko pociatocnych krokov siet bezi s teacher-forcingom
%esn- siet
%


internalResponse = zeros(length(esn.x), steps);
error = 0;

for i = 1:steps
     %save the n - th output to outputSequence
    internalResponse(:,i) = esn.x;
    outputSequence(i) = esn.y; 
    
    if (i <= forceLength)
        NetOut = desired(i);
    else 
        NetOut = esn.y;
        error = error + (desired(i) - esn.y)^2;
    end
    % calculate x(n + 1)
    esn.x = unitFunction(esn.resWeights * esn.x + esn.feedbackWeights * NetOut);
    % calculate y(n + 1)
    esn.y = esn.outWeights * esn.x; %unitFunction(); 
end

error = error / (steps - forceLength) ;