function [outputSequence internalResponse error esn] = online_train(input, desiredOutput, alpha, esn)
%train postupnost inputSequence sa spracuje ako vstup siete esn.
%Vysledkom je vystupna sekvencia outputSequence, ktora zodpoveda vystupu
%siete

desiredLength = length(desiredOutput);

internalResponse = zeros(length(esn.x), desiredLength);
error = zeros(1, desiredLength);

% collecting state and output matrices during teacher forcing
for i = 1:desiredLength

    
    internalResponse(:,i) = esn.x;
    outputSequence(i) = esn.y; 

    
    for n = 1:esn.nOutputs
        error(i) = error(i) + sum((desiredOutput(i, n) - esn.y(n)) .^ 2);
        delta = (((esn.y(n) - desiredOutput(i, n)) * alpha) .* [input(i) esn.x']);   %* (1 - esn.y(n) ^ 2)
        esn.outWeights(n, :) = esn.outWeights(n, :) - delta;
    end     
    
    % x_n+1                                                              x_n                                d_n
    esn.x = unitFunction(esn.inWeights * input(i)' +  esn.resWeights * esn.x + esn.feedbackWeights * desiredOutput(i));
    % calculate y(n + 1)
    esn.y = esn.outWeights * [input(i)' ; esn.x]; 
    
    
end


